/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.user;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class GroupMembershipQuery {
    public static final int DEFAULT_PAGE_INDEX = 1;
    public static final int DEFAULT_PAGE_SIZE = 100;
    public static final String ANY = "ANY";
    public static final String IN = "IN";
    public static final String OUT = "OUT";
    public static final Set<String> AVAILABLE_MEMBERSHIP = ImmutableSet.of((Object)"ANY", (Object)"IN", (Object)"OUT");
    private final String organizationUuid;
    private final String membership;
    private final String groupSearch;
    final String groupSearchSql;
    private final int pageSize;
    private final int pageIndex;

    private GroupMembershipQuery(Builder builder, String organizationUuid) {
        this.membership = builder.membership;
        this.groupSearch = builder.groupSearch;
        this.organizationUuid = organizationUuid;
        this.groupSearchSql = GroupMembershipQuery.groupSearchToSql(this.groupSearch);
        this.pageSize = builder.pageSize;
        this.pageIndex = builder.pageIndex;
    }

    private static String groupSearchToSql(@Nullable String s) {
        String sql = null;
        if (s != null) {
            sql = StringUtils.replace((String)StringUtils.upperCase((String)s), (String)"%", (String)"/%");
            sql = StringUtils.replace((String)sql, (String)"_", (String)"/_");
            sql = "%" + sql + "%";
        }
        return sql;
    }

    public String organizationUuid() {
        return this.organizationUuid;
    }

    @CheckForNull
    public String membership() {
        return this.membership;
    }

    @CheckForNull
    public String groupSearch() {
        return this.groupSearch;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int pageIndex() {
        return this.pageIndex;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String organizationUuid;
        private String membership;
        private String groupSearch;
        private Integer pageIndex = 1;
        private Integer pageSize = 100;

        private Builder() {
        }

        public Builder organizationUuid(String organizationUuid) {
            this.organizationUuid = organizationUuid;
            return this;
        }

        public Builder membership(@Nullable String membership) {
            this.membership = membership;
            return this;
        }

        public Builder groupSearch(@Nullable String s) {
            this.groupSearch = StringUtils.defaultIfBlank((String)s, null);
            return this;
        }

        public Builder pageSize(@Nullable Integer i) {
            this.pageSize = i;
            return this;
        }

        public Builder pageIndex(@Nullable Integer i) {
            this.pageIndex = i;
            return this;
        }

        private void initMembership() {
            this.membership = (String)MoreObjects.firstNonNull((Object)this.membership, (Object)GroupMembershipQuery.ANY);
            Preconditions.checkArgument((boolean)AVAILABLE_MEMBERSHIP.contains(this.membership), (Object)("Membership is not valid (got " + this.membership + "). Availables values are " + AVAILABLE_MEMBERSHIP));
        }

        private void initPageSize() {
            this.pageSize = (Integer)MoreObjects.firstNonNull((Object)this.pageSize, (Object)100);
        }

        private void initPageIndex() {
            this.pageIndex = (Integer)MoreObjects.firstNonNull((Object)this.pageIndex, (Object)1);
            Preconditions.checkArgument((this.pageIndex > 0 ? 1 : 0) != 0, (Object)("Page index must be greater than 0 (got " + this.pageIndex + ")"));
        }

        public GroupMembershipQuery build() {
            Preconditions.checkNotNull((Object)this.organizationUuid, (Object)"Organization uuid cant be null");
            this.initMembership();
            this.initPageIndex();
            this.initPageSize();
            return new GroupMembershipQuery(this, this.organizationUuid);
        }
    }
}

