/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.user;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.ibatis.session.ResultHandler;
import org.sonar.api.user.UserQuery;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserMapper;

public class UserDao
implements Dao {
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public UserDao(System2 system2, UuidFactory uuidFactory) {
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    @CheckForNull
    public UserDto selectUserById(DbSession session, int userId) {
        return UserDao.mapper(session).selectUser(userId);
    }

    @CheckForNull
    public UserDto selectByUuid(DbSession session, String uuid) {
        return UserDao.mapper(session).selectByUuid(uuid);
    }

    public List<UserDto> selectByIds(DbSession session, Collection<Integer> ids) {
        return DatabaseUtils.executeLargeInputs(ids, UserDao.mapper(session)::selectByIds);
    }

    @CheckForNull
    public UserDto selectActiveUserByLogin(DbSession session, String login) {
        UserMapper mapper = UserDao.mapper(session);
        return mapper.selectUserByLogin(login);
    }

    public List<UserDto> selectByLogins(DbSession session, Collection<String> logins) {
        return DatabaseUtils.executeLargeInputs(logins, UserDao.mapper(session)::selectByLogins);
    }

    public List<UserDto> selectByUuids(DbSession session, Collection<String> uuids) {
        return DatabaseUtils.executeLargeInputs(uuids, UserDao.mapper(session)::selectByUuids);
    }

    public List<UserDto> selectByOrderedLogins(DbSession session, Collection<String> logins) {
        List<UserDto> unordered = this.selectByLogins(session, logins);
        return logins.stream().map(new LoginToUser(unordered)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<UserDto> selectUsers(DbSession dbSession, UserQuery query) {
        return UserDao.mapper(dbSession).selectUsers(query);
    }

    public long countRootUsersButLogin(DbSession dbSession, String login) {
        return UserDao.mapper(dbSession).countRootUsersButLogin(login);
    }

    public UserDto insert(DbSession session, UserDto dto) {
        long now = this.system2.now();
        UserDao.mapper(session).insert(dto.setUuid(this.uuidFactory.create()).setCreatedAt(now).setUpdatedAt(now));
        return dto;
    }

    public UserDto update(DbSession session, UserDto dto) {
        UserDao.mapper(session).update(dto.setUpdatedAt(this.system2.now()));
        return dto;
    }

    public void setRoot(DbSession session, String login, boolean root) {
        UserDao.mapper(session).setRoot(login, root, this.system2.now());
    }

    public void deactivateUser(DbSession dbSession, UserDto user) {
        UserDao.mapper(dbSession).deactivateUser(user.getLogin(), this.system2.now());
    }

    public void cleanHomepage(DbSession dbSession, OrganizationDto organization) {
        UserDao.mapper(dbSession).clearHomepages("ORGANIZATION", organization.getUuid(), this.system2.now());
    }

    public void cleanHomepage(DbSession dbSession, ComponentDto project) {
        UserDao.mapper(dbSession).clearHomepages("PROJECT", project.uuid(), this.system2.now());
    }

    public void cleanHomepage(DbSession dbSession, UserDto user) {
        UserDao.mapper(dbSession).clearHomepage(user.getLogin(), this.system2.now());
    }

    @CheckForNull
    public UserDto selectByLogin(DbSession session, String login) {
        return UserDao.mapper(session).selectByLogin(login);
    }

    public List<UserDto> selectByScmAccountOrLoginOrEmail(DbSession session, String scmAccountOrLoginOrEmail) {
        String like = "%" + '\n' + scmAccountOrLoginOrEmail + '\n' + "%";
        return UserDao.mapper(session).selectNullableByScmAccountOrLoginOrEmail(scmAccountOrLoginOrEmail, like);
    }

    public List<UserDto> selectByEmail(DbSession dbSession, String emailCaseInsensitive) {
        return UserDao.mapper(dbSession).selectByEmail(emailCaseInsensitive.toLowerCase(Locale.ENGLISH));
    }

    @CheckForNull
    public UserDto selectByExternalIdAndIdentityProvider(DbSession dbSession, String externalId, String externalIdentityProvider) {
        return UserDao.mapper(dbSession).selectByExternalIdAndIdentityProvider(externalId, externalIdentityProvider);
    }

    public void scrollByUuids(DbSession dbSession, Collection<String> uuids, Consumer<UserDto> consumer) {
        UserMapper mapper = UserDao.mapper(dbSession);
        DatabaseUtils.executeLargeInputsWithoutOutput(uuids, pageOfUuids -> mapper.selectByUuids((List<String>)pageOfUuids).forEach(consumer));
    }

    public void scrollAll(DbSession dbSession, Consumer<UserDto> consumer) {
        UserDao.mapper(dbSession).scrollAll((ResultHandler<UserDto>)((ResultHandler)context -> {
            UserDto user = (UserDto)context.getResultObject();
            consumer.accept(user);
        }));
    }

    private static UserMapper mapper(DbSession session) {
        return (UserMapper)session.getMapper(UserMapper.class);
    }

    private static class LoginToUser
    implements Function<String, UserDto> {
        private final Map<String, UserDto> map = new HashMap<String, UserDto>();

        private LoginToUser(Collection<UserDto> unordered) {
            for (UserDto dto : unordered) {
                this.map.put(dto.getLogin(), dto);
            }
        }

        @Override
        public UserDto apply(@Nonnull String login) {
            return this.map.get(login);
        }
    }
}

