/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.webhook;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.webhook.WebhookDto;
import org.sonar.db.webhook.WebhookMapper;

public class WebhookDao
implements Dao {
    private final System2 system2;

    public WebhookDao(System2 system2) {
        this.system2 = system2;
    }

    public Optional<WebhookDto> selectByUuid(DbSession dbSession, String uuid) {
        return Optional.ofNullable(WebhookDao.mapper(dbSession).selectByUuid(uuid));
    }

    public List<WebhookDto> selectByOrganization(DbSession dbSession, OrganizationDto organizationDto) {
        return WebhookDao.mapper(dbSession).selectForOrganizationUuidOrderedByName(organizationDto.getUuid());
    }

    public List<WebhookDto> selectByOrganizationUuid(DbSession dbSession, String organizationUuid) {
        return WebhookDao.mapper(dbSession).selectForOrganizationUuidOrderedByName(organizationUuid);
    }

    public List<WebhookDto> selectByProject(DbSession dbSession, ComponentDto componentDto) {
        return WebhookDao.mapper(dbSession).selectForProjectUuidOrderedByName(componentDto.uuid());
    }

    public void insert(DbSession dbSession, WebhookDto dto) {
        Preconditions.checkState((dto.getOrganizationUuid() != null || dto.getProjectUuid() != null ? 1 : 0) != 0, (Object)"A webhook can not be created if not linked to an organization or a project.");
        Preconditions.checkState((dto.getOrganizationUuid() == null || dto.getProjectUuid() == null ? 1 : 0) != 0, (Object)"A webhook can not be linked to both an organization and a project.");
        WebhookDao.mapper(dbSession).insert(dto.setCreatedAt(this.system2.now()).setUpdatedAt(this.system2.now()));
    }

    public void update(DbSession dbSession, WebhookDto dto) {
        WebhookDao.mapper(dbSession).update(dto.setUpdatedAt(this.system2.now()));
    }

    public void delete(DbSession dbSession, String uuid) {
        WebhookDao.mapper(dbSession).delete(uuid);
    }

    public void deleteByOrganization(DbSession dbSession, OrganizationDto organization) {
        WebhookDao.mapper(dbSession).deleteForOrganizationUuid(organization.getUuid());
    }

    public void deleteByProject(DbSession dbSession, ComponentDto componentDto) {
        WebhookDao.mapper(dbSession).deleteForProjectUuid(componentDto.uuid());
    }

    private static WebhookMapper mapper(DbSession dbSession) {
        return (WebhookMapper)dbSession.getMapper(WebhookMapper.class);
    }
}

