/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.charset;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.platform.db.migration.charset.CharsetHandler;
import org.sonar.server.platform.db.migration.charset.ColumnDef;
import org.sonar.server.platform.db.migration.charset.DatabaseCharsetChecker;
import org.sonar.server.platform.db.migration.charset.SqlExecutor;

class MysqlCharsetHandler
extends CharsetHandler {
    private static final Logger LOGGER = Loggers.get(MysqlCharsetHandler.class);
    private static final String TYPE_LONGTEXT = "longtext";

    MysqlCharsetHandler(SqlExecutor selectExecutor) {
        super(selectExecutor);
    }

    @Override
    void handle(Connection connection, DatabaseCharsetChecker.State state) throws SQLException {
        if (state == DatabaseCharsetChecker.State.UPGRADE) {
            this.repairCaseInsensitiveColumns(connection);
        }
    }

    private void repairCaseInsensitiveColumns(Connection connection) throws SQLException {
        List<ColumnDef> columns = this.getSqlExecutor().select(connection, "select table_name, column_name, character_set_name, collation_name, data_type, character_maximum_length, is_nullable FROM INFORMATION_SCHEMA.columns WHERE table_schema=database() and character_set_name is not null and collation_name is not null", ColumnDef.ColumnDefRowConverter.INSTANCE);
        List invalidColumns = columns.stream().filter(ColumnDef::isInSonarQubeTable).filter(column -> StringUtils.endsWithIgnoreCase((String)column.getCollation(), (String)"_ci")).collect(Collectors.toList());
        for (ColumnDef column2 : invalidColumns) {
            this.repairCaseInsensitiveColumn(connection, column2);
        }
    }

    private void repairCaseInsensitiveColumn(Connection connection, ColumnDef column) throws SQLException {
        String csCollation = MysqlCharsetHandler.toCaseSensitive(column.getCollation());
        String nullability = column.isNullable() ? "NULL" : "NOT NULL";
        String type = column.getDataType().equalsIgnoreCase(TYPE_LONGTEXT) ? TYPE_LONGTEXT : String.format("%s(%d)", column.getDataType(), column.getSize());
        String alterSql = String.format("ALTER TABLE %s MODIFY %s %s CHARACTER SET '%s' COLLATE '%s' %s", column.getTable(), column.getColumn(), type, column.getCharset(), csCollation, nullability);
        LOGGER.info("Changing collation of column [{}.{}] from {} to {} |\u00a0sql={}", new Object[]{column.getTable(), column.getColumn(), column.getCollation(), csCollation, alterSql});
        this.getSqlExecutor().executeDdl(connection, alterSql);
    }

    private static String toCaseSensitive(String caseInsensitiveCollation) {
        return StringUtils.substringBefore((String)caseInsensitiveCollation, (String)"_") + "_bin";
    }
}

