/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.charset;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.platform.db.migration.charset.CharsetHandler;
import org.sonar.server.platform.db.migration.charset.DatabaseCharsetChecker;
import org.sonar.server.platform.db.migration.charset.PostgresMetadataReader;
import org.sonar.server.platform.db.migration.charset.SqlExecutor;

class PostgresCharsetHandler
extends CharsetHandler {
    private final PostgresMetadataReader metadata;

    PostgresCharsetHandler(SqlExecutor selectExecutor, PostgresMetadataReader metadata) {
        super(selectExecutor);
        this.metadata = metadata;
    }

    @Override
    void handle(Connection connection, DatabaseCharsetChecker.State state) throws SQLException {
        this.expectUtf8AsDefault(connection);
        if (state == DatabaseCharsetChecker.State.UPGRADE || state == DatabaseCharsetChecker.State.STARTUP) {
            this.expectUtf8Columns(connection);
        }
    }

    private void expectUtf8AsDefault(Connection connection) throws SQLException {
        Loggers.get(this.getClass()).info("Verify that database charset supports UTF8");
        String collation = this.metadata.getDefaultCharset(connection);
        if (!StringUtils.containsIgnoreCase((String)collation, (String)"utf8")) {
            throw MessageException.of((String)String.format("Database charset is %s. It must support UTF8.", collation));
        }
    }

    private void expectUtf8Columns(Connection connection) throws SQLException {
        List<String[]> rows = this.getSqlExecutor().select(connection, "select table_name, column_name, collation_name from information_schema.columns where table_schema='public' and udt_name='varchar' order by table_name, column_name", new SqlExecutor.StringsConverter(3));
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        for (String[] row : rows) {
            if (StringUtils.isBlank((String)row[2]) || StringUtils.containsIgnoreCase((String)row[2], (String)"utf8")) continue;
            errors.add(String.format("%s.%s", row[0], row[1]));
        }
        if (!errors.isEmpty()) {
            throw MessageException.of((String)String.format("Database columns [%s] must have UTF8 charset.", Joiner.on((String)", ").join(errors)));
        }
    }

    @VisibleForTesting
    PostgresMetadataReader getMetadata() {
        return this.metadata;
    }
}

