/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.def;

import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.AbstractColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;

@Immutable
public class BigIntegerColumnDef
extends AbstractColumnDef {
    private BigIntegerColumnDef(Builder builder) {
        super(builder.columnName, builder.isNullable, null);
    }

    public static Builder newBigIntegerColumnDefBuilder() {
        return new Builder();
    }

    @Override
    public String generateSqlType(Dialect dialect) {
        return dialect.getId().equals("oracle") ? "NUMBER (38)" : "BIGINT";
    }

    public static class Builder {
        @CheckForNull
        private String columnName;
        private boolean isNullable = true;

        public Builder setColumnName(String columnName) {
            this.columnName = Validations.validateColumnName(columnName);
            return this;
        }

        public Builder setIsNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public BigIntegerColumnDef build() {
            Validations.validateColumnName(this.columnName);
            return new BigIntegerColumnDef(this);
        }
    }
}

