/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.def;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public class Validations {
    private static final int TABLE_NAME_MAX_SIZE = 25;
    private static final int CONSTRAINT_NAME_MAX_SIZE = 30;
    private static final int INDEX_NAME_MAX_SIZE = 30;
    private static final CharMatcher DIGIT_CHAR_MATCHER = CharMatcher.inRange((char)'0', (char)'9');
    private static final CharMatcher LOWER_CASE_ASCII_LETTERS_CHAR_MATCHER = CharMatcher.inRange((char)'a', (char)'z');
    private static final CharMatcher UNDERSCORE_CHAR_MATCHER = CharMatcher.anyOf((CharSequence)"_");

    private Validations() {
    }

    public static String validateColumnName(@Nullable String columnName) {
        String name = Objects.requireNonNull(columnName, "Column name cannot be null");
        Validations.checkDbIdentifierCharacters(columnName, "Column name");
        return name;
    }

    public static String validateTableName(@Nullable String tableName) {
        Objects.requireNonNull(tableName, "Table name cannot be null");
        Validations.checkDbIdentifier(tableName, "Table name", 25);
        return tableName;
    }

    public static String validateConstraintName(@Nullable String constraintName) {
        Objects.requireNonNull(constraintName, "Constraint name cannot be null");
        Validations.checkDbIdentifier(constraintName, "Constraint name", 30);
        return constraintName;
    }

    public static String validateIndexName(@Nullable String indexName) {
        Objects.requireNonNull(indexName, "Index name cannot be null");
        Validations.checkDbIdentifier(indexName, "Index name", 30);
        return indexName;
    }

    static String checkDbIdentifier(@Nullable String identifier, String identifierDesc, int maxSize) {
        String res = (String)Preconditions.checkNotNull((Object)identifier, (String)"%s can't be null", (Object[])new Object[]{identifierDesc});
        Preconditions.checkArgument((!res.isEmpty() ? 1 : 0) != 0, (String)"%s, can't be empty", (Object[])new Object[]{identifierDesc});
        Preconditions.checkArgument((identifier.length() <= maxSize ? 1 : 0) != 0, (String)"%s length can't be more than %s", (Object[])new Object[]{identifierDesc, maxSize});
        Validations.checkDbIdentifierCharacters(identifier, identifierDesc);
        return res;
    }

    private static void checkDbIdentifierCharacters(String identifier, String identifierDesc) {
        Preconditions.checkArgument((identifier.length() > 0 ? 1 : 0) != 0, (Object)"Identifier must not be empty");
        Preconditions.checkArgument((boolean)LOWER_CASE_ASCII_LETTERS_CHAR_MATCHER.or(DIGIT_CHAR_MATCHER).or(CharMatcher.anyOf((CharSequence)"_")).matchesAllOf((CharSequence)identifier), (String)"%s must be lower case and contain only alphanumeric chars or '_', got '%s'", (Object[])new Object[]{identifierDesc, identifier});
        Preconditions.checkArgument((boolean)DIGIT_CHAR_MATCHER.or(UNDERSCORE_CHAR_MATCHER).matchesNoneOf(identifier.subSequence(0, 1)), (String)"%s must not start by a number or '_', got '%s'", (Object[])new Object[]{identifierDesc, identifier});
    }
}

