/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.engine;

import java.util.Arrays;
import java.util.HashSet;
import org.sonar.server.platform.db.migration.engine.MigrationContainer;
import org.sonar.server.platform.db.migration.engine.MigrationContainerPopulator;
import org.sonar.server.platform.db.migration.step.MigrationStep;
import org.sonar.server.platform.db.migration.step.MigrationSteps;
import org.sonar.server.platform.db.migration.step.MigrationStepsExecutorImpl;
import org.sonar.server.platform.db.migration.version.DbVersion;

public class MigrationContainerPopulatorImpl
implements MigrationContainerPopulator {
    private final DbVersion[] dbVersions;

    public MigrationContainerPopulatorImpl(DbVersion ... dbVersions) {
        this.dbVersions = dbVersions;
    }

    public void populateContainer(MigrationContainer container) {
        container.add(new Object[]{MigrationStepsExecutorImpl.class});
        this.populateFromDbVersion(container);
        MigrationContainerPopulatorImpl.populateFromMigrationSteps(container);
    }

    private void populateFromDbVersion(MigrationContainer container) {
        Arrays.stream(this.dbVersions).flatMap(DbVersion::getSupportComponents).forEach(xva$0 -> container.add(new Object[]{xva$0}));
    }

    private static void populateFromMigrationSteps(MigrationContainer container) {
        MigrationSteps migrationSteps = (MigrationSteps)container.getComponentByType(MigrationSteps.class);
        HashSet classes = new HashSet();
        migrationSteps.readAll().forEach(step -> {
            Class<? extends MigrationStep> stepClass = step.getStepClass();
            if (!classes.contains(stepClass)) {
                container.add(new Object[]{stepClass});
                classes.add(stepClass);
            }
        });
    }
}

