/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.engine;

import java.util.Optional;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.server.platform.db.migration.engine.MigrationContainerImpl;
import org.sonar.server.platform.db.migration.engine.MigrationContainerPopulator;
import org.sonar.server.platform.db.migration.engine.MigrationEngine;
import org.sonar.server.platform.db.migration.history.MigrationHistory;
import org.sonar.server.platform.db.migration.step.MigrationSteps;
import org.sonar.server.platform.db.migration.step.MigrationStepsExecutor;

public class MigrationEngineImpl
implements MigrationEngine {
    private final MigrationHistory migrationHistory;
    private final ComponentContainer serverContainer;
    private final MigrationContainerPopulator populator;
    private final MigrationSteps migrationSteps;

    public MigrationEngineImpl(MigrationHistory migrationHistory, ComponentContainer serverContainer, MigrationContainerPopulator populator, MigrationSteps migrationSteps) {
        this.migrationHistory = migrationHistory;
        this.serverContainer = serverContainer;
        this.populator = populator;
        this.migrationSteps = migrationSteps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        MigrationContainerImpl migrationContainer = new MigrationContainerImpl(this.serverContainer, this.populator);
        try {
            MigrationStepsExecutor stepsExecutor = (MigrationStepsExecutor)migrationContainer.getComponentByType(MigrationStepsExecutor.class);
            Optional<Long> lastMigrationNumber = this.migrationHistory.getLastMigrationNumber();
            if (lastMigrationNumber.isPresent()) {
                stepsExecutor.execute(this.migrationSteps.readFrom(lastMigrationNumber.get() + 1L));
            } else {
                stepsExecutor.execute(this.migrationSteps.readAll());
            }
        }
        finally {
            migrationContainer.cleanup();
        }
    }
}

