/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.history;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.server.platform.db.migration.history.MigrationHistory;
import org.sonar.server.platform.db.migration.step.RegisteredMigrationStep;

public class MigrationHistoryImpl
implements MigrationHistory {
    private static final String SCHEMA_MIGRATIONS_TABLE = "schema_migrations";
    private final Database database;

    public MigrationHistoryImpl(Database database) {
        this.database = database;
    }

    @Override
    public void start() {
        try (Connection connection = this.database.getDataSource().getConnection();){
            Preconditions.checkState((boolean)DatabaseUtils.tableExists((String)SCHEMA_MIGRATIONS_TABLE, (Connection)connection), (Object)"Migration history table is missing");
        }
        catch (SQLException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public void stop() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Long> getLastMigrationNumber() {
        try (Connection connection = this.database.getDataSource().getConnection();){
            List<Long> versions = MigrationHistoryImpl.selectVersions(connection);
            if (!versions.isEmpty()) {
                Optional<Long> optional = Optional.of(versions.get(versions.size() - 1));
                return optional;
            }
            Optional<Long> optional = Optional.empty();
            return optional;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to read content of table schema_migrations", e);
        }
    }

    @Override
    public void done(RegisteredMigrationStep dbMigration) {
        long migrationNumber = dbMigration.getMigrationNumber();
        try (Connection connection = this.database.getDataSource().getConnection();
             PreparedStatement statement = connection.prepareStatement("insert into schema_migrations(version) values (?)");){
            statement.setString(1, String.valueOf(migrationNumber));
            statement.execute();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(String.format("Failed to insert row with value %s in table %s", migrationNumber, SCHEMA_MIGRATIONS_TABLE), e);
        }
    }

    /*
     * Exception decompiling
     */
    private static List<Long> selectVersions(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

