/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.sql;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.ColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;

public class RenameColumnsBuilder {
    private final Dialect dialect;
    private final String tableName;
    private final List<Renaming> renamings = new ArrayList<Renaming>();

    public RenameColumnsBuilder(Dialect dialect, String tableName) {
        this.dialect = dialect;
        this.tableName = tableName;
    }

    public RenameColumnsBuilder renameColumn(String oldColumnName, ColumnDef columnDef) {
        this.renamings.add(new Renaming(oldColumnName, columnDef));
        return this;
    }

    public List<String> build() {
        Validations.validateTableName(this.tableName);
        this.renamings.forEach(r -> {
            Validations.validateColumnName(r.getOldColumnName());
            Validations.validateColumnName(r.getNewColumnName());
            Preconditions.checkArgument((!r.getNewColumnName().equals(r.getOldColumnName()) ? 1 : 0) != 0, (Object)"Column names must be different");
        });
        return this.createSqlStatement();
    }

    private List<String> createSqlStatement() {
        return this.renamings.stream().map(r -> {
            switch (this.dialect.getId()) {
                case "h2": {
                    return "ALTER TABLE " + this.tableName + " ALTER COLUMN " + r.getOldColumnName() + " RENAME TO " + r.getNewColumnName();
                }
                case "oracle": 
                case "postgresql": {
                    return "ALTER TABLE " + this.tableName + " RENAME COLUMN " + r.getOldColumnName() + " TO " + r.getNewColumnName();
                }
                case "mysql": {
                    return "ALTER TABLE " + this.tableName + " CHANGE " + r.getOldColumnName() + " " + r.getNewColumnName() + " " + r.generateSqlType(this.dialect);
                }
                case "mssql": {
                    return "EXEC sp_rename '" + this.tableName + "." + r.getOldColumnName() + "', '" + r.getNewColumnName() + "', 'COLUMN'";
                }
            }
            throw new IllegalArgumentException("Unsupported dialect id " + this.dialect.getId());
        }).collect(Collectors.toList());
    }

    private static class Renaming
    implements ColumnDef {
        private final ColumnDef columnDef;
        private final String oldColumnName;

        private Renaming(String oldColumnName, ColumnDef columnDef) {
            this.columnDef = columnDef;
            this.oldColumnName = oldColumnName;
        }

        public String getOldColumnName() {
            return this.oldColumnName;
        }

        public String getNewColumnName() {
            return this.columnDef.getName();
        }

        @Override
        public boolean isNullable() {
            return this.columnDef.isNullable();
        }

        @Override
        public String getName() {
            return this.columnDef.getName();
        }

        @Override
        public String generateSqlType(Dialect dialect) {
            return this.columnDef.generateSqlType(dialect);
        }

        @Override
        @CheckForNull
        public Object getDefaultValue() {
            return this.columnDef.getDefaultValue();
        }
    }
}

