/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.step;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.sonar.core.util.ProgressLogger;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SelectImpl;
import org.sonar.server.platform.db.migration.step.SqlStatement;
import org.sonar.server.platform.db.migration.step.Upsert;
import org.sonar.server.platform.db.migration.step.UpsertImpl;

public class MassUpdate {
    private final Database db;
    private final Connection readConnection;
    private final Connection writeConnection;
    private final AtomicLong counter = new AtomicLong(0L);
    private final ProgressLogger progress = ProgressLogger.create(this.getClass(), (AtomicLong)this.counter);
    private Select select;
    private List<UpsertImpl> updates = new ArrayList<UpsertImpl>(1);

    public MassUpdate(Database db, Connection readConnection, Connection writeConnection) {
        this.db = db;
        this.readConnection = readConnection;
        this.writeConnection = writeConnection;
    }

    public SqlStatement select(String sql) throws SQLException {
        this.select = SelectImpl.create(this.db, this.readConnection, sql);
        return this.select;
    }

    public Upsert update(String sql) throws SQLException {
        UpsertImpl upsert = UpsertImpl.create(this.writeConnection, sql);
        this.updates.add(upsert);
        return upsert;
    }

    public MassUpdate rowPluralName(String s) {
        this.progress.setPluralLabel(s);
        return this;
    }

    public void execute(Handler handler) throws SQLException {
        Preconditions.checkState((this.select != null && !this.updates.isEmpty() ? 1 : 0) != 0, (Object)"SELECT or UPDATE requests are not defined");
        Preconditions.checkState((this.updates.size() == 1 ? 1 : 0) != 0, (Object)("There should be only one update when using a " + Handler.class.getName()));
        this.progress.start();
        try {
            this.select.scroll(row -> this.callSingleHandler(handler, this.updates.iterator().next(), row));
            this.closeUpdates();
            this.progress.log();
        }
        finally {
            this.progress.stop();
        }
    }

    public void execute(MultiHandler handler) throws SQLException {
        Preconditions.checkState((this.select != null && !this.updates.isEmpty() ? 1 : 0) != 0, (Object)"SELECT or UPDATE(s) requests are not defined");
        this.progress.start();
        try {
            this.select.scroll(row -> this.callMultiHandler(handler, this.updates, row));
            this.closeUpdates();
            this.progress.log();
        }
        finally {
            this.progress.stop();
        }
    }

    private void callSingleHandler(Handler handler, Upsert update, Select.Row row) throws SQLException {
        if (handler.handle(row, update)) {
            update.addBatch();
        }
        this.counter.getAndIncrement();
    }

    private void callMultiHandler(MultiHandler handler, List<UpsertImpl> updates, Select.Row row) throws SQLException {
        int i = 0;
        for (UpsertImpl update : updates) {
            if (handler.handle(row, update, i)) {
                update.addBatch();
            }
            ++i;
        }
        this.counter.getAndIncrement();
    }

    private void closeUpdates() throws SQLException {
        for (UpsertImpl update : this.updates) {
            if (update.getBatchCount() > 0L) {
                update.execute().commit();
            }
            update.close();
        }
    }

    @FunctionalInterface
    public static interface MultiHandler {
        public boolean handle(Select.Row var1, SqlStatement var2, int var3) throws SQLException;
    }

    @FunctionalInterface
    public static interface Handler {
        public boolean handle(Select.Row var1, SqlStatement var2) throws SQLException;
    }
}

