/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.sonar.server.platform.db.migration.step.MigrationNumber;
import org.sonar.server.platform.db.migration.step.MigrationSteps;
import org.sonar.server.platform.db.migration.step.RegisteredMigrationStep;

class MigrationStepsImpl
implements MigrationSteps {
    private final List<RegisteredMigrationStep> steps;

    MigrationStepsImpl(List<RegisteredMigrationStep> steps) {
        Objects.requireNonNull(steps, "steps can't be null");
        Preconditions.checkArgument((!steps.isEmpty() ? 1 : 0) != 0, (Object)"steps can't be empty");
        this.steps = ImmutableList.copyOf(steps);
    }

    @Override
    public long getMaxMigrationNumber() {
        return this.steps.get(this.steps.size() - 1).getMigrationNumber();
    }

    @Override
    public Stream<RegisteredMigrationStep> readAll() {
        return this.steps.stream();
    }

    @Override
    public Stream<RegisteredMigrationStep> readFrom(long migrationNumber) {
        MigrationNumber.validate(migrationNumber);
        int startingIndex = this.lookupIndexOfClosestTo(migrationNumber);
        if (startingIndex < 0) {
            return Stream.empty();
        }
        return this.steps.subList(startingIndex, this.steps.size()).stream();
    }

    private int lookupIndexOfClosestTo(long startingPoint) {
        int index = 0;
        for (RegisteredMigrationStep step : this.steps) {
            if (step.getMigrationNumber() >= startingPoint) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

