/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v56;

import java.sql.SQLException;
import java.util.Date;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Upsert;

public class PopulateInitialSchema
extends DataChange {
    private static final String ADMINS_GROUP = "sonar-administrators";
    private static final String USERS_GROUP = "sonar-users";
    private static final String ADMIN_USER = "admin";
    private final System2 system2;

    public PopulateInitialSchema(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        this.insertGroups(context);
        PopulateInitialSchema.insertGroupRoles(context);
        this.insertAdminUser(context);
        PopulateInitialSchema.insertGroupMemberships(context);
    }

    private void insertGroups(DataChange.Context context) throws SQLException {
        PopulateInitialSchema.truncateTable(context, "groups");
        Date now = new Date(this.system2.now());
        Upsert upsert = context.prepareUpsert("insert into groups (name, description, created_at, updated_at) values (?, ?, ?, ?)");
        ((Upsert)((Upsert)((Upsert)((Upsert)upsert.setString(1, ADMINS_GROUP)).setString(2, "System administrators")).setDate(3, now)).setDate(4, now)).addBatch();
        ((Upsert)((Upsert)((Upsert)((Upsert)upsert.setString(1, USERS_GROUP)).setString(2, "Any new users created will automatically join this group")).setDate(3, now)).setDate(4, now)).addBatch();
        upsert.execute().commit();
    }

    private static void insertGroupRoles(DataChange.Context context) throws SQLException {
        PopulateInitialSchema.truncateTable(context, "group_roles");
        Upsert upsert = context.prepareUpsert("insert into group_roles (group_id, resource_id, role) values ((select id from groups where name='sonar-administrators'), null, ?)");
        ((Upsert)upsert.setString(1, ADMIN_USER)).addBatch();
        ((Upsert)upsert.setString(1, "profileadmin")).addBatch();
        ((Upsert)upsert.setString(1, "gateadmin")).addBatch();
        ((Upsert)upsert.setString(1, "shareDashboard")).addBatch();
        ((Upsert)upsert.setString(1, "provisioning")).addBatch();
        upsert.execute().commit();
        upsert = context.prepareUpsert("insert into group_roles (group_id, resource_id, role) values (null, null, ?)");
        ((Upsert)upsert.setString(1, "scan")).addBatch();
        ((Upsert)upsert.setString(1, "provisioning")).addBatch();
        upsert.execute().commit();
    }

    private void insertAdminUser(DataChange.Context context) throws SQLException {
        PopulateInitialSchema.truncateTable(context, "users");
        long now = this.system2.now();
        ((Upsert)((Upsert)((Upsert)context.prepareUpsert("insert into users (login, name, email, external_identity, external_identity_provider, user_local, crypted_password, salt, created_at, updated_at, remember_token, remember_token_expires_at) values ('admin', 'Administrator', '', 'admin', 'sonarqube', ?, 'a373a0e667abb2604c1fd571eb4ad47fe8cc0878', '48bc4b0d93179b5103fd3885ea9119498e9d161b', ?, ?, null, null)").setBoolean(1, true)).setLong(2, now)).setLong(3, now)).execute().commit();
    }

    private static void insertGroupMemberships(DataChange.Context context) throws SQLException {
        PopulateInitialSchema.truncateTable(context, "groups_users");
        Upsert upsert = context.prepareUpsert("insert into groups_users (user_id, group_id) values ((select id from users where login='admin'), (select id from groups where name=?))");
        ((Upsert)upsert.setString(1, ADMINS_GROUP)).addBatch();
        ((Upsert)upsert.setString(1, USERS_GROUP)).addBatch();
        upsert.execute().commit();
    }

    private static void truncateTable(DataChange.Context context, String table) throws SQLException {
        context.prepareUpsert("truncate table " + table).execute().commit();
    }
}

