/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v561;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class UpdateUsersExternalIdentityWhenEmpty
extends DataChange {
    private final System2 system2;

    public UpdateUsersExternalIdentityWhenEmpty(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT u.id, u.login FROM users u WHERE external_identity_provider IS NULL OR external_identity IS NULL");
        massUpdate.update("UPDATE users SET external_identity_provider=?, external_identity=?, updated_at=? WHERE id=?");
        massUpdate.rowPluralName("users");
        massUpdate.execute(new MigrationHandler(this.system2.now()));
    }

    private static class MigrationHandler
    implements MassUpdate.Handler {
        private final long now;

        public MigrationHandler(long now) {
            this.now = now;
        }

        @Override
        public boolean handle(Select.Row row, SqlStatement update) throws SQLException {
            update.setString(1, "sonarqube");
            update.setString(2, row.getString(2));
            update.setLong(3, this.now);
            update.setLong(4, row.getLong(1));
            return true;
        }
    }
}

