/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class FixProjectUuidOfDeveloperProjects
extends DataChange {
    public FixProjectUuidOfDeveloperProjects(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select distinct p.person_id,d.uuid from projects p, projects d where p.qualifier = 'DEV_PRJ' and p.project_uuid != d.uuid and d.id = p.person_id");
        massUpdate.update("update projects set project_uuid = ? where person_id = ? and qualifier = 'DEV_PRJ' and project_uuid != ?");
        massUpdate.rowPluralName("developers with incorrect project_uuid");
        massUpdate.execute(FixProjectUuidOfDeveloperProjects::handleComponent);
    }

    private static boolean handleComponent(Select.Row row, SqlStatement update) throws SQLException {
        long personId = row.getLong(1);
        String developerUuid = row.getString(2);
        update.setString(1, developerUuid);
        update.setLong(2, personId);
        update.setString(3, developerUuid);
        return true;
    }
}

