/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateLastUsedColumnOfRulesProfiles
extends DataChange {
    private static final Pattern PATTERN_QP_KEY = Pattern.compile("\"key\"\\s*:\\s*\"(.*?)\"");

    public PopulateLastUsedColumnOfRulesProfiles(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        Map<String, Long> lastAnalysisDatesByQualityProfileKey = PopulateLastUsedColumnOfRulesProfiles.buildQualityProfilesMap(context);
        if (lastAnalysisDatesByQualityProfileKey.isEmpty()) {
            return;
        }
        PopulateLastUsedColumnOfRulesProfiles.populateLastUsedColumn(context, lastAnalysisDatesByQualityProfileKey);
    }

    private static Map<String, Long> buildQualityProfilesMap(DataChange.Context context) throws SQLException {
        HashMap<String, Long> lastAnalysisDatesByQPKeys = new HashMap<String, Long>();
        ((Select)context.prepareSelect("select s.created_at, pm.text_value from project_measures pm   inner join snapshots s on pm.snapshot_id = s.id   inner join metrics m on pm.metric_id=m.id where s.islast=?   and m.name='quality_profiles' order by s.created_at ").setBoolean(1, true)).scroll(row -> {
            long analysisDate = row.getLong(1);
            String json = row.getString(2);
            Matcher matcher = PATTERN_QP_KEY.matcher(json);
            while (matcher.find()) {
                lastAnalysisDatesByQPKeys.put(matcher.group(1), analysisDate);
            }
        });
        return lastAnalysisDatesByQPKeys;
    }

    private static void populateLastUsedColumn(DataChange.Context context, Map<String, Long> lastAnalysisDatesByQualityProfileKey) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select id, kee from rules_profiles where last_used is null");
        massUpdate.update("update rules_profiles set last_used=? where id=?");
        massUpdate.rowPluralName("rules_profiles");
        massUpdate.execute((Select.Row row, SqlStatement update) -> PopulateLastUsedColumnOfRulesProfiles.handle(lastAnalysisDatesByQualityProfileKey, row, update));
    }

    private static boolean handle(Map<String, Long> lastAnalysisDatesByQualityProfileKey, Select.Row row, SqlStatement update) throws SQLException {
        int qualityProfileId = row.getInt(1);
        String qualityProfileKey = row.getString(2);
        update.setLong(1, lastAnalysisDatesByQualityProfileKey.get(qualityProfileKey));
        update.setInt(2, qualityProfileId);
        return true;
    }
}

