/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v62;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.Upsert;

public class UpdateQualityGateConditionsOnCoverage
extends DataChange {
    private static final Logger LOGGER = Loggers.get(UpdateQualityGateConditionsOnCoverage.class);
    private static final List<String> COVERAGE_METRIC_KEYS = ImmutableList.of((Object)"coverage", (Object)"lines_to_cover", (Object)"uncovered_lines", (Object)"line_coverage", (Object)"conditions_to_cover", (Object)"uncovered_conditions", (Object)"branch_coverage");
    private static final String OVERALL_PREFIX = "overall_";
    private static final String IT_PREFIX = "it_";
    private static final String NEW_PREFIX = "new_";

    public UpdateQualityGateConditionsOnCoverage(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        List<Metric> metrics = UpdateQualityGateConditionsOnCoverage.selectMetrics(context);
        if (metrics.isEmpty()) {
            return;
        }
        List<Long> qualityGateIds = context.prepareSelect("select id from quality_gates").list(Select.LONG_READER);
        if (qualityGateIds.isEmpty()) {
            return;
        }
        LOGGER.info("Migrating {} quality gates", (Object)qualityGateIds.size());
        new Migration(context, metrics, qualityGateIds).execute();
    }

    private static List<Metric> selectMetrics(DataChange.Context context) throws SQLException {
        ArrayList<String> metricKeys = new ArrayList<String>(COVERAGE_METRIC_KEYS);
        metricKeys.addAll(COVERAGE_METRIC_KEYS.stream().map(metricKey -> IT_PREFIX + metricKey).collect(Collectors.toList()));
        metricKeys.addAll(COVERAGE_METRIC_KEYS.stream().map(metricKey -> OVERALL_PREFIX + metricKey).collect(Collectors.toList()));
        metricKeys.addAll(metricKeys.stream().map(metricKey -> NEW_PREFIX + metricKey).collect(Collectors.toList()));
        Select select = context.prepareSelect("select id, name from metrics where name in (" + StringUtils.repeat((String)"?", (String)",", (int)metricKeys.size()) + ")");
        for (int i = 0; i < metricKeys.size(); ++i) {
            select.setString(i + 1, (String)metricKeys.get(i));
        }
        return select.list(Metric::new);
    }

    private static class Metric {
        private final long id;
        private final String key;

        Metric(Select.Row row) throws SQLException {
            this.id = Objects.requireNonNull(row.getLong(1));
            this.key = Objects.requireNonNull(row.getString(2));
        }

        long getId() {
            return this.id;
        }

        String getKey() {
            return this.key;
        }
    }

    private static class QualityGateCondition {
        private final long id;
        private final long metricId;

        QualityGateCondition(Select.Row row) throws SQLException {
            this.id = Objects.requireNonNull(row.getLong(1));
            this.metricId = Objects.requireNonNull(row.getLong(2));
        }

        long getId() {
            return this.id;
        }

        long getMetricId() {
            return this.metricId;
        }
    }

    private static class Migration {
        private final DataChange.Context context;
        private final Map<String, Metric> metricsByMetricKeys;
        private final List<Long> metricIds;
        private final List<Long> qualityGateIds;

        Migration(DataChange.Context context, List<Metric> metrics, List<Long> qualityGateIds) {
            this.context = context;
            this.metricsByMetricKeys = (Map)metrics.stream().collect(MoreCollectors.uniqueIndex(Metric::getKey, Function.identity()));
            this.metricIds = metrics.stream().map(Metric::getId).collect(Collectors.toList());
            this.qualityGateIds = qualityGateIds;
        }

        public void execute() {
            this.qualityGateIds.forEach(this::processQualityGate);
        }

        private void processQualityGate(long qualityGateId) {
            List<QualityGateCondition> qualityGateConditions = this.selectQualityGateConditions(qualityGateId, this.metricIds);
            Multimap qualityGateConditionsByMetricId = (Multimap)qualityGateConditions.stream().collect(MoreCollectors.index(QualityGateCondition::getMetricId, Function.identity()));
            COVERAGE_METRIC_KEYS.forEach(metric -> {
                this.processConditions((String)metric, UpdateQualityGateConditionsOnCoverage.OVERALL_PREFIX + metric, UpdateQualityGateConditionsOnCoverage.IT_PREFIX + metric, (Multimap<Long, QualityGateCondition>)qualityGateConditionsByMetricId, qualityGateId);
                this.processConditions(UpdateQualityGateConditionsOnCoverage.NEW_PREFIX + metric, "new_overall_" + metric, "new_it_" + metric, (Multimap<Long, QualityGateCondition>)qualityGateConditionsByMetricId, qualityGateId);
            });
        }

        private void processConditions(String coverageMetricKey, String overallMetricKey, String itMetricKey, Multimap<Long, QualityGateCondition> qualityGateConditionsByMetricId, long qualityGateId) {
            try {
                Collection<QualityGateCondition> conditionsOnCoverage = this.getConditionsByMetricKey(coverageMetricKey, qualityGateConditionsByMetricId);
                Collection<QualityGateCondition> conditionsOnOverallCoverage = this.getConditionsByMetricKey(overallMetricKey, qualityGateConditionsByMetricId);
                Collection<QualityGateCondition> conditionsOnItCoverage = this.getConditionsByMetricKey(itMetricKey, qualityGateConditionsByMetricId);
                if (conditionsOnCoverage.isEmpty() && conditionsOnOverallCoverage.isEmpty() && conditionsOnItCoverage.isEmpty()) {
                    return;
                }
                if (!conditionsOnOverallCoverage.isEmpty()) {
                    this.removeQualityGateConditions(conditionsOnCoverage);
                    this.removeQualityGateConditions(conditionsOnItCoverage);
                    this.updateQualityGateConditions(conditionsOnOverallCoverage, coverageMetricKey);
                } else if (!conditionsOnCoverage.isEmpty()) {
                    this.removeQualityGateConditions(conditionsOnItCoverage);
                } else {
                    this.updateQualityGateConditions(conditionsOnItCoverage, coverageMetricKey);
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException(String.format("Fail to update quality gate conditions of quality gate %s", qualityGateId), e);
            }
        }

        private Collection<QualityGateCondition> getConditionsByMetricKey(String metricKey, Multimap<Long, QualityGateCondition> qualityGateConditionsByMetricId) {
            Metric metric = this.metricsByMetricKeys.get(metricKey);
            if (metric == null) {
                return Collections.emptyList();
            }
            return qualityGateConditionsByMetricId.get((Object)metric.getId());
        }

        private List<QualityGateCondition> selectQualityGateConditions(long qualityGateId, List<Long> metricIds) {
            try {
                Select select = (Select)this.context.prepareSelect("select qgc.id, qgc.metric_id from quality_gate_conditions qgc where qgc.qgate_id=? and qgc.metric_id in (" + StringUtils.repeat((String)"?", (String)" , ", (int)metricIds.size()) + ")").setLong(1, qualityGateId);
                for (int i = 0; i < metricIds.size(); ++i) {
                    select.setLong(i + 2, metricIds.get(i));
                }
                return select.list(QualityGateCondition::new);
            }
            catch (SQLException e) {
                throw new IllegalStateException(String.format("Fail to select quality gate conditions of quality gate %s", qualityGateId), e);
            }
        }

        private void updateQualityGateConditions(Collection<QualityGateCondition> conditions, String metricKey) throws SQLException {
            Upsert upsert = this.context.prepareUpsert("update quality_gate_conditions set metric_id=? where id=?");
            conditions.forEach(condition -> {
                try {
                    ((Upsert)((Upsert)upsert.setLong(1, this.metricsByMetricKeys.get(metricKey).getId())).setLong(2, condition.getId())).execute().commit();
                }
                catch (SQLException e) {
                    Throwables.propagate((Throwable)e);
                }
            });
        }

        private void removeQualityGateConditions(Collection<QualityGateCondition> conditions) throws SQLException {
            if (conditions.isEmpty()) {
                return;
            }
            Upsert upsert = this.context.prepareUpsert("delete from quality_gate_conditions where id=?");
            conditions.forEach(condition -> {
                try {
                    ((Upsert)upsert.setLong(1, condition.getId())).execute().commit();
                }
                catch (SQLException e) {
                    Throwables.propagate((Throwable)e);
                }
            });
        }
    }
}

