/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v63;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;
import org.sonar.server.platform.db.migration.version.v63.DefaultOrganizationUuidProvider;

public class PopulateOrganizationUuidToProjects
extends DataChange {
    private final DefaultOrganizationUuidProvider defaultOrganizationUuid;

    public PopulateOrganizationUuidToProjects(Database db, DefaultOrganizationUuidProvider defaultOrganizationUuid) {
        super(db);
        this.defaultOrganizationUuid = defaultOrganizationUuid;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        String organizationUuid = this.defaultOrganizationUuid.get(context);
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select uuid from projects where organization_uuid is null and project_uuid = uuid");
        massUpdate.update("update projects set organization_uuid=? where project_uuid=?");
        massUpdate.rowPluralName("project trees");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String uuid = row.getString(1);
            update.setString(1, organizationUuid);
            update.setString(2, uuid);
            return true;
        });
        massUpdate = context.prepareMassUpdate();
        massUpdate.select("select uuid from projects where organization_uuid is null");
        massUpdate.update("update projects set organization_uuid=? where uuid=?");
        massUpdate.rowPluralName("components");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String uuid = row.getString(1);
            update.setString(1, organizationUuid);
            update.setString(2, uuid);
            return true;
        });
    }
}

