/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v64;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateColumnProjectsPrivate
extends DataChange {
    public PopulateColumnProjectsPrivate(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select distinct root_uuid from projects where private is null");
        massUpdate.update("update projects set private = ? where root_uuid = ?");
        massUpdate.rowPluralName("component tree without private flag");
        massUpdate.execute(PopulateColumnProjectsPrivate::handle);
    }

    private static boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        String rootUuid = row.getString(1);
        update.setBoolean(1, false);
        update.setString(2, rootUuid);
        return true;
    }
}

