/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v64;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class SetCopyComponentUuidOnLocalViews
extends DataChange {
    private static final String QUALIFIER_SUB_VIEW = "SVW";
    private static final String QUALIFIER_VIEW = "VW";
    private static final String SCOPE_PROJECT = "PRJ";

    public SetCopyComponentUuidOnLocalViews(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        Map<String, String> rootUuidsByKeys = SetCopyComponentUuidOnLocalViews.selectRootUuidsByKeys(context);
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT p.kee, p.uuid FROM projects p WHERE p.qualifier = ? AND p.scope = ? AND p.copy_component_uuid IS NULL AND p.enabled = ? ").setString(1, QUALIFIER_SUB_VIEW).setString(2, SCOPE_PROJECT).setBoolean(3, true);
        massUpdate.update("UPDATE projects set copy_component_uuid=? WHERE uuid=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String subViewKey = row.getString(1);
            int lastViewKeyIndex = subViewKey.lastIndexOf(58);
            if (lastViewKeyIndex < 0) {
                return false;
            }
            String possibleRootViewUuid = subViewKey.substring(lastViewKeyIndex + 1);
            String rootUuid = (String)rootUuidsByKeys.get(possibleRootViewUuid);
            if (rootUuid == null) {
                return false;
            }
            update.setString(1, rootUuid);
            update.setString(2, row.getString(2));
            return true;
        });
    }

    private static Map<String, String> selectRootUuidsByKeys(DataChange.Context context) throws SQLException {
        HashMap<String, String> rootUuids = new HashMap<String, String>();
        ((Select)((Select)((Select)context.prepareSelect("SELECT p.kee, p.uuid FROM projects p WHERE p.qualifier = ? AND p.scope = ? AND p.enabled = ? ").setString(1, QUALIFIER_VIEW)).setString(2, SCOPE_PROJECT)).setBoolean(3, true)).scroll(row -> {
            String key = row.getString(1);
            String uuid = row.getString(2);
            rootUuids.put(key, uuid);
        });
        return rootUuids;
    }
}

