/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v67;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class CleanupDisabledUsers
extends DataChange {
    private final System2 system2;
    private final String falseValue;

    public CleanupDisabledUsers(Database db, System2 system2) {
        super(db);
        this.falseValue = db.getDialect().getFalseSqlValue();
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select u.id from users u where u.active = " + this.falseValue + " and ( email is not null or   crypted_password is not null or   salt is not null or   external_identity is not null or   external_identity_provider is not null ) ");
        massUpdate.update("update users set   email = null,   crypted_password = null,   salt = null,   external_identity = null,   external_identity_provider = null,   updated_at = ?  where id = ?");
        massUpdate.rowPluralName("deactivated users");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setLong(1, now);
            update.setLong(2, row.getLong(1));
            return true;
        });
    }
}

