/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v67;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class DropOldLicenses
extends DataChange {
    private static final String LICENSE_HASH_SECURED_SUFFIX = ".licenseHash.secured";
    private static final String LICENSE_SECURED_SUFFIX = ".license.secured";

    public DropOldLicenses(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select prop_key from properties where prop_key like ?").setString(1, "%.licenseHash.secured");
        massUpdate.update("delete from properties where prop_key = ? or prop_key = ?");
        massUpdate.rowPluralName("old license properties");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String licenseHashKey = row.getString(1);
            String licenseKey = licenseHashKey.replace(LICENSE_HASH_SECURED_SUFFIX, "") + LICENSE_SECURED_SUFFIX;
            update.setString(1, licenseHashKey);
            update.setString(2, licenseKey);
            return true;
        });
    }
}

