/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v70;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.List;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateDefaultQualityGate
extends DataChange {
    private final System2 system2;

    public PopulateDefaultQualityGate(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        List<String> builtInQGUuids = ((Select)context.prepareSelect("select uuid from quality_gates where is_built_in = ?").setBoolean(1, true)).list(row -> row.getString(1));
        Preconditions.checkState((!builtInQGUuids.isEmpty() ? 1 : 0) != 0, (Object)"Unable to find the builtin quality gate");
        Preconditions.checkState((builtInQGUuids.size() == 1 ? 1 : 0) != 0, (Object)"There are too many built in quality gates, one and only one is expected");
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select uuid from organizations  where default_quality_gate_uuid is null");
        massUpdate.rowPluralName("organizations");
        massUpdate.update("update organizations set default_quality_gate_uuid = ?, updated_at=? where uuid = ?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setString(1, (String)builtInQGUuids.get(0));
            update.setLong(2, now);
            update.setString(3, row.getString(1));
            return true;
        });
    }
}

