/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v71;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class CleanBrokenProjectToQGReferences
extends DataChange {
    private static final String PROPERTY_SONAR_QUALITYGATE = "sonar.qualitygate";

    public CleanBrokenProjectToQGReferences(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        HashSet qualityGateIds = new HashSet();
        context.prepareSelect("select id from quality_gates").scroll(s -> qualityGateIds.add(String.valueOf(s.getInt(1))));
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select distinct text_value from properties where  prop_key=?  and text_value is not null  and resource_id is not null").setString(1, PROPERTY_SONAR_QUALITYGATE);
        massUpdate.update("delete from properties where  prop_key=?  and resource_id is not null  and text_value=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> CleanBrokenProjectToQGReferences.handle(row, update, qualityGateIds));
    }

    private static boolean handle(Select.Row row, SqlStatement update, Set<String> qualityGateIds) throws SQLException {
        String qgId = row.getString(1);
        if (qualityGateIds.contains(qgId)) {
            return false;
        }
        update.setString(1, PROPERTY_SONAR_QUALITYGATE);
        update.setString(2, qgId);
        return true;
    }
}

