/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v71;

import com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import java.util.List;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateTableProjectLinks2
extends DataChange {
    private static final String TYPE_HOME_PAGE = "homepage";
    private static final String TYPE_CI = "ci";
    private static final String TYPE_ISSUE_TRACKER = "issue";
    private static final String TYPE_SOURCES = "scm";
    private static final String TYPE_SOURCES_DEV = "scm_dev";
    private static final List<String> PROVIDED_TYPES = ImmutableList.of((Object)"homepage", (Object)"ci", (Object)"issue", (Object)"scm");
    private static final String SCOPE_PROJECT = "PRJ";
    private static final String QUALIFIER_PROJECT = "TRK";
    private final UuidFactory uuidFactory;
    private final System2 system2;

    public PopulateTableProjectLinks2(Database db, UuidFactory uuidFactory, System2 system2) {
        super(db);
        this.uuidFactory = uuidFactory;
        this.system2 = system2;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT p.component_uuid, p.link_type, p.name, p.href from project_links p inner join projects prj on prj.uuid=p.component_uuid and prj.scope=? and prj.qualifier=?  left outer join project_links2 p2 on p2.project_uuid=p.component_uuid     and p2.href=p.href    and p2.link_type=p.link_type    and (p2.name=p.name or (p2.name is null and p.link_type in (?, ?, ?, ?))) where p2.uuid is null order by p.id").setString(1, SCOPE_PROJECT).setString(2, QUALIFIER_PROJECT).setString(3, TYPE_HOME_PAGE).setString(4, TYPE_CI).setString(5, TYPE_ISSUE_TRACKER).setString(6, TYPE_SOURCES);
        massUpdate.update("insert into project_links2 (uuid, project_uuid, link_type, name, href, created_at, updated_at) values  (?, ?, ?, ?, ?, ?, ?)");
        massUpdate.rowPluralName("project links");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String componentUuid = row.getString(1);
            String linkType = row.getString(2);
            String name = row.getString(3);
            String href = row.getString(4);
            if (linkType.equals(TYPE_SOURCES_DEV)) {
                return false;
            }
            update.setString(1, this.uuidFactory.create());
            update.setString(2, componentUuid);
            update.setString(3, linkType);
            if (PROVIDED_TYPES.contains(linkType)) {
                update.setString(4, null);
            } else {
                update.setString(4, name);
            }
            update.setString(5, href);
            update.setLong(6, now);
            update.setLong(7, now);
            return true;
        });
    }
}

