/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v72;

import java.sql.SQLException;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateOrganizationUuidOnUsers
extends DataChange {
    private final System2 system2;

    public PopulateOrganizationUuidOnUsers(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("users");
        massUpdate.select("SELECT u.id, o.uuid FROM users u INNER JOIN organizations o ON o.user_id=u.id WHERE u.organization_uuid IS NULL");
        massUpdate.update("UPDATE users SET organization_uuid=?, updated_at=? WHERE id=?");
        long now = this.system2.now();
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            long id = row.getLong(1);
            String organizationUuid = row.getString(2);
            update.setString(1, organizationUuid);
            update.setLong(2, now);
            update.setLong(3, id);
            return true;
        });
    }
}

