/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v72;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;

public class PurgeOrphansForCE
extends DataChange {
    public PurgeOrphansForCE(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        switch (this.getDialect().getId()) {
            case "mssql": 
            case "mysql": {
                PurgeOrphansForCE.executeForMySQLAndMsSQL(context);
                break;
            }
            default: {
                PurgeOrphansForCE.executeGeneric(context);
            }
        }
    }

    private static void executeGeneric(DataChange.Context context) throws SQLException {
        context.prepareUpsert("delete from ce_task_characteristics ctc where not exists (select 1 from ce_activity ca where ca.uuid = ctc.task_uuid)").execute().commit();
        context.prepareUpsert("delete from ce_task_input cti where not exists (select 1 from ce_activity ca where ca.uuid = cti.task_uuid)").execute().commit();
        context.prepareUpsert("delete from ce_scanner_context csc where not exists (select 1 from ce_activity ca where ca.uuid = csc.task_uuid)").execute().commit();
    }

    private static void executeForMySQLAndMsSQL(DataChange.Context context) throws SQLException {
        context.prepareUpsert("delete ctc from ce_task_characteristics as ctc where not exists (select 1 from ce_activity ca where ca.uuid = ctc.task_uuid)").execute().commit();
        context.prepareUpsert("delete cti from ce_task_input as cti where not exists (select 1 from ce_activity ca where ca.uuid = cti.task_uuid)").execute().commit();
        context.prepareUpsert("delete csc from ce_scanner_context as csc where not exists (select 1 from ce_activity ca where ca.uuid = csc.task_uuid)").execute().commit();
    }
}

