/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.suffixtree;

import com.google.common.base.Objects;
import org.sonar.duplications.detector.suffixtree.Edge;
import org.sonar.duplications.detector.suffixtree.Node;
import org.sonar.duplications.detector.suffixtree.Suffix;
import org.sonar.duplications.detector.suffixtree.Text;

public final class SuffixTree {
    final Text text;
    private final Node root;

    private SuffixTree(Text text) {
        this.text = text;
        this.root = new Node(this, null);
    }

    public static SuffixTree create(Text text) {
        SuffixTree tree = new SuffixTree(text);
        Suffix active = new Suffix(tree.root, 0, -1);
        for (int i = 0; i < text.length(); ++i) {
            tree.addPrefix(active, i);
        }
        return tree;
    }

    private void addPrefix(Suffix active, int endIndex) {
        Node parentNode;
        Node lastParentNode = null;
        while (true) {
            Edge edge;
            parentNode = active.getOriginNode();
            if (active.isExplicit()) {
                edge = active.getOriginNode().findEdge(this.symbolAt(endIndex));
                if (edge != null) {
                    break;
                }
            } else {
                edge = active.getOriginNode().findEdge(this.symbolAt(active.getBeginIndex()));
                int span = active.getSpan();
                if (Objects.equal((Object)this.symbolAt(edge.getBeginIndex() + span + 1), (Object)this.symbolAt(endIndex))) break;
                parentNode = edge.splitEdge(active);
            }
            Edge newEdge = new Edge(endIndex, this.text.length() - 1, parentNode);
            newEdge.insert();
            this.updateSuffixNode(lastParentNode, parentNode);
            lastParentNode = parentNode;
            if (active.getOriginNode() == this.root) {
                active.incBeginIndex();
            } else {
                active.changeOriginNode();
            }
            active.canonize();
        }
        this.updateSuffixNode(lastParentNode, parentNode);
        active.incEndIndex();
        active.canonize();
    }

    private void updateSuffixNode(Node node, Node suffixNode) {
        if (node != null && !node.equals(this.root)) {
            node.setSuffixNode(suffixNode);
        }
    }

    public Object symbolAt(int index) {
        return this.text.symbolAt(index);
    }

    public Node getRootNode() {
        return this.root;
    }
}

