/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.home.cache;

import java.io.File;
import javax.annotation.Nullable;
import org.sonar.home.cache.FileCache;
import org.sonar.home.cache.Logger;

public class FileCacheBuilder {
    private final Logger logger;
    private File userHome;

    public FileCacheBuilder(Logger logger) {
        this.logger = logger;
    }

    public FileCacheBuilder setUserHome(File d) {
        this.userHome = d;
        return this;
    }

    public FileCacheBuilder setUserHome(@Nullable String path) {
        this.userHome = path == null ? null : new File(path);
        return this;
    }

    public FileCache build() {
        if (this.userHome == null) {
            this.userHome = FileCacheBuilder.findHome();
        }
        File cacheDir = new File(this.userHome, "cache");
        return FileCache.create(cacheDir, this.logger);
    }

    private static File findHome() {
        String path = System.getenv("SONAR_USER_HOME");
        if (path == null) {
            path = System.getProperty("user.home") + File.separator + ".sonar";
        }
        return new File(path);
    }
}

