/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.markdown;

import org.sonar.channel.RegexChannel;
import org.sonar.markdown.MarkdownOutput;

class HtmlUrlChannel
extends RegexChannel<MarkdownOutput> {
    public HtmlUrlChannel() {
        super("https?://[\\w\\d:#@%/;$()~_?\\+-=\\.&]++");
    }

    protected void consume(CharSequence token, MarkdownOutput output) {
        String url = token.toString();
        boolean isRelativeUrl = !url.contains("://");
        output.append("<a href=\"");
        output.append(url);
        output.append(isRelativeUrl ? "\">" : "\" target=\"_blank\" rel=\"noopener noreferrer\">");
        output.append(url);
        output.append("</a>");
    }
}

