/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.markdown;

import org.sonar.channel.RegexChannel;
import org.sonar.markdown.MarkdownOutput;

public class HtmlHeadingChannel
extends RegexChannel<MarkdownOutput> {
    private static final int MAX_HEADING_DEPTH = 6;

    public HtmlHeadingChannel() {
        super("\\s*=+\\s[^\r\n]*+[\r\n]*");
    }

    protected void consume(CharSequence token, MarkdownOutput output) {
        int index;
        int headingLevel = 0;
        for (index = 0; index < token.length() && Character.isWhitespace(token.charAt(index)); ++index) {
        }
        while (index < token.length() && index <= 6 && token.charAt(index) == '=') {
            ++index;
            ++headingLevel;
        }
        while (index < token.length() && Character.isWhitespace(token.charAt(index))) {
            ++index;
        }
        CharSequence headingText = token.subSequence(index, token.length());
        output.append("<h" + headingLevel + ">");
        output.append(headingText.toString().trim());
        output.append("</h" + headingLevel + ">");
    }
}

