/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.rule.internal;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.rule.AdHocRule;
import org.sonar.api.batch.sensor.rule.NewAdHocRule;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rules.CleanCodeAttribute;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.Preconditions;

public class DefaultAdHocRule
extends DefaultStorable
implements AdHocRule,
NewAdHocRule {
    private Severity severity;
    private RuleType type;
    private String name;
    private String description;
    private String engineId;
    private String ruleId;
    private CleanCodeAttribute cleanCodeAttribute;
    private Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> impacts = new EnumMap<SoftwareQuality, org.sonar.api.issue.impact.Severity>(SoftwareQuality.class);

    public DefaultAdHocRule() {
        super(null);
    }

    public DefaultAdHocRule(@Nullable SensorStorage storage) {
        super(storage);
    }

    public DefaultAdHocRule severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public DefaultAdHocRule addDefaultImpact(SoftwareQuality softwareQuality, org.sonar.api.issue.impact.Severity severity) {
        this.impacts.put(softwareQuality, severity);
        return this;
    }

    public String engineId() {
        return this.engineId;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public String name() {
        return this.name;
    }

    @CheckForNull
    public String description() {
        return this.description;
    }

    public Severity severity() {
        return this.severity;
    }

    @Override
    public void doSave() {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.engineId), (String)"Engine id is mandatory on ad hoc rule");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.ruleId), (String)"Rule id is mandatory on ad hoc rule");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.name), (String)"Name is mandatory on every ad hoc rule");
        Preconditions.checkState((!this.impacts.isEmpty() || this.severity != null && this.type != null ? 1 : 0) != 0, (String)"Impact should be provided, or Severity and Type instead");
        this.storage.store((AdHocRule)this);
    }

    public RuleType type() {
        return this.type;
    }

    public Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> defaultImpacts() {
        return this.impacts.isEmpty() ? Map.of(SoftwareQuality.MAINTAINABILITY, org.sonar.api.issue.impact.Severity.MEDIUM) : this.impacts;
    }

    @CheckForNull
    public CleanCodeAttribute cleanCodeAttribute() {
        return this.cleanCodeAttribute == null ? CleanCodeAttribute.defaultCleanCodeAttribute() : this.cleanCodeAttribute;
    }

    public DefaultAdHocRule engineId(String engineId) {
        this.engineId = engineId;
        return this;
    }

    public DefaultAdHocRule ruleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public DefaultAdHocRule name(String name) {
        this.name = name;
        return this;
    }

    public DefaultAdHocRule description(@Nullable String description) {
        this.description = description;
        return this;
    }

    public DefaultAdHocRule type(RuleType type) {
        this.type = type;
        return this;
    }

    public DefaultAdHocRule cleanCodeAttribute(CleanCodeAttribute cleanCodeAttribute) {
        this.cleanCodeAttribute = cleanCodeAttribute;
        return this;
    }
}

