/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.impl.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Startable;
import org.sonar.api.utils.TempFolder;

public class DefaultTempFolder
implements TempFolder,
Startable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTempFolder.class);
    private final File tempDir;
    private final boolean deleteOnExit;

    public DefaultTempFolder(File tempDir) {
        this(tempDir, false);
    }

    public DefaultTempFolder(File tempDir, boolean deleteOnExit) {
        this.tempDir = tempDir;
        this.deleteOnExit = deleteOnExit;
    }

    public File newDir() {
        return DefaultTempFolder.createTempDir(this.tempDir.toPath()).toFile();
    }

    private static Path createTempDir(Path baseDir) {
        try {
            return Files.createTempDirectory(baseDir, null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp directory", e);
        }
    }

    public File newDir(String name) {
        File dir = new File(this.tempDir, name);
        try {
            FileUtils.forceMkdir((File)dir);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp directory - " + dir, e);
        }
        return dir;
    }

    public File newFile() {
        return this.newFile(null, null);
    }

    public File newFile(@Nullable String prefix, @Nullable String suffix) {
        return DefaultTempFolder.createTempFile(this.tempDir.toPath(), prefix, suffix).toFile();
    }

    private static Path createTempFile(Path baseDir, String prefix, String suffix) {
        try {
            return Files.createTempFile(baseDir, prefix, suffix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp file", e);
        }
    }

    public void clean() {
        try {
            if (this.tempDir.exists()) {
                Files.walkFileTree(this.tempDir.toPath(), DeleteRecursivelyFileVisitor.INSTANCE);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to delete temp folder", (Throwable)e);
        }
    }

    public void start() {
    }

    public void stop() {
        if (this.deleteOnExit) {
            this.clean();
        }
    }

    private static final class DeleteRecursivelyFileVisitor
    extends SimpleFileVisitor<Path> {
        public static final DeleteRecursivelyFileVisitor INSTANCE = new DeleteRecursivelyFileVisitor();

        private DeleteRecursivelyFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

