/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;

@Immutable
public class NewActiveRule {
    final RuleKey ruleKey;
    final String name;
    final String severity;
    final Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> impacts;
    final Map<String, String> params;
    final long createdAt;
    final long updatedAt;
    final String internalKey;
    final String language;
    final String templateRuleKey;
    final String qProfileKey;
    final Set<RuleKey> deprecatedKeys;

    NewActiveRule(Builder builder) {
        this.ruleKey = builder.ruleKey;
        this.name = builder.name;
        this.severity = builder.severity;
        this.impacts = builder.impacts;
        this.params = builder.params;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.internalKey = builder.internalKey;
        this.language = builder.language;
        this.templateRuleKey = builder.templateRuleKey;
        this.qProfileKey = builder.qProfileKey;
        this.deprecatedKeys = builder.deprecatedKeys;
    }

    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    public static class Builder {
        private RuleKey ruleKey;
        private String name;
        private String severity = Severity.defaultSeverity();
        private final Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> impacts = new EnumMap<SoftwareQuality, org.sonar.api.issue.impact.Severity>(SoftwareQuality.class);
        private Map<String, String> params = new HashMap<String, String>();
        private long createdAt;
        private long updatedAt;
        private String internalKey;
        private String language;
        private String templateRuleKey;
        private String qProfileKey;
        private Set<RuleKey> deprecatedKeys = new HashSet<RuleKey>();

        public Builder setRuleKey(RuleKey ruleKey) {
            this.ruleKey = ruleKey;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setSeverity(@Nullable String severity) {
            this.severity = (String)StringUtils.defaultIfBlank((CharSequence)severity, (CharSequence)Severity.defaultSeverity());
            return this;
        }

        public Builder setImpact(SoftwareQuality softwareQuality, org.sonar.api.issue.impact.Severity severity) {
            this.impacts.put(softwareQuality, severity);
            return this;
        }

        public Builder setParam(String key, @Nullable String value) {
            if (value == null) {
                this.params.remove(key);
            } else {
                this.params.put(key, value);
            }
            return this;
        }

        public Builder setCreatedAt(long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder setUpdatedAt(long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder setInternalKey(@Nullable String internalKey) {
            this.internalKey = internalKey;
            return this;
        }

        public Builder setLanguage(@Nullable String language) {
            this.language = language;
            return this;
        }

        public Builder setTemplateRuleKey(@Nullable String templateRuleKey) {
            this.templateRuleKey = templateRuleKey;
            return this;
        }

        public Builder setQProfileKey(String qProfileKey) {
            this.qProfileKey = qProfileKey;
            return this;
        }

        public Builder setDeprecatedKeys(Set<RuleKey> deprecatedKeys) {
            this.deprecatedKeys = deprecatedKeys;
            return this;
        }

        public NewActiveRule build() {
            return new NewActiveRule(this);
        }
    }
}

