/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.nio.file.Path;
import java.util.Arrays;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.PathUtils;
import org.sonar.api.utils.WildcardPattern;

@ThreadSafe
public abstract class PathPattern {
    private static final Logger LOG = LoggerFactory.getLogger(PathPattern.class);
    @Deprecated
    private static final String ABSOLUTE_PATH_PATTERN_PREFIX = "file:";
    final WildcardPattern pattern;

    PathPattern(String pattern) {
        this.pattern = WildcardPattern.create((String)pattern);
    }

    public abstract boolean match(Path var1, Path var2);

    public abstract boolean match(Path var1, Path var2, boolean var3);

    public static PathPattern create(String s) {
        String trimmed = StringUtils.trim((String)s);
        if (Strings.CI.startsWith((CharSequence)trimmed, (CharSequence)ABSOLUTE_PATH_PATTERN_PREFIX)) {
            LOG.warn("Using absolute path pattern is deprecated. Please use relative path instead of '{}'", (Object)trimmed);
            return new AbsolutePathPattern(StringUtils.substring((String)trimmed, (int)ABSOLUTE_PATH_PATTERN_PREFIX.length()));
        }
        return new RelativePathPattern(trimmed);
    }

    public static PathPattern[] create(String[] s) {
        return (PathPattern[])Arrays.stream(s).map(PathPattern::create).toArray(PathPattern[]::new);
    }

    static String sanitizeExtension(String suffix) {
        return StringUtils.lowerCase((String)Strings.CS.removeStart(suffix, (CharSequence)"."));
    }

    @Deprecated
    private static class AbsolutePathPattern
    extends PathPattern {
        private AbsolutePathPattern(String pattern) {
            super(pattern);
        }

        @Override
        public boolean match(Path absolutePath, Path relativePath) {
            return this.match(absolutePath, relativePath, true);
        }

        @Override
        public boolean match(Path absolutePath, Path relativePath, boolean caseSensitiveFileExtension) {
            String extension;
            Object path = PathUtils.sanitize((String)absolutePath.toString());
            if (!caseSensitiveFileExtension && StringUtils.isNotBlank((CharSequence)(extension = AbsolutePathPattern.sanitizeExtension(FilenameUtils.getExtension((String)path))))) {
                path = Strings.CI.removeEnd((String)path, (CharSequence)extension);
                path = (String)path + extension;
            }
            return this.pattern.match((String)path);
        }

        public String toString() {
            return PathPattern.ABSOLUTE_PATH_PATTERN_PREFIX + this.pattern.toString();
        }
    }

    private static class RelativePathPattern
    extends PathPattern {
        private RelativePathPattern(String pattern) {
            super(pattern);
        }

        @Override
        public boolean match(Path absolutePath, Path relativePath) {
            return this.match(absolutePath, relativePath, true);
        }

        @Override
        public boolean match(Path absolutePath, Path relativePath, boolean caseSensitiveFileExtension) {
            String extension;
            Object path = PathUtils.sanitize((String)relativePath.toString());
            if (!caseSensitiveFileExtension && StringUtils.isNotBlank((CharSequence)(extension = RelativePathPattern.sanitizeExtension(FilenameUtils.getExtension((String)path))))) {
                path = Strings.CI.removeEnd((String)path, (CharSequence)extension);
                path = (String)path + extension;
            }
            return path != null && this.pattern.match((String)path);
        }

        public String toString() {
            return this.pattern.toString();
        }
    }
}

