/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.utils.Preconditions;

public abstract class DefaultStorable {
    protected final SensorStorage storage;
    private boolean saved = false;

    public DefaultStorable() {
        this.storage = null;
    }

    public DefaultStorable(@Nullable SensorStorage storage) {
        this.storage = storage;
    }

    public final void save() {
        Objects.requireNonNull(this.storage, "No persister on this object");
        Preconditions.checkState((!this.saved ? 1 : 0) != 0, (String)"This object was already saved");
        this.doSave();
        this.saved = true;
    }

    protected abstract void doSave();

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

