/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.fix.NewQuickFix;
import org.sonar.api.batch.sensor.issue.fix.QuickFix;
import org.sonar.api.batch.sensor.issue.internal.AbstractDefaultIssue;
import org.sonar.api.batch.sensor.issue.internal.NoOpNewQuickFix;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Preconditions;

public class DefaultIssue
extends AbstractDefaultIssue<DefaultIssue>
implements Issue,
NewIssue {
    private final Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> overridenImpacts = new EnumMap<SoftwareQuality, org.sonar.api.issue.impact.Severity>(SoftwareQuality.class);
    private RuleKey ruleKey;
    private Double gap;
    private Severity overriddenSeverity;
    private boolean quickFixAvailable = false;
    private String ruleDescriptionContextKey;
    private List<String> codeVariants;
    private List<String> internalTags;

    public DefaultIssue(DefaultInputProject project) {
        this(project, null);
    }

    public DefaultIssue(DefaultInputProject project, @Nullable SensorStorage storage) {
        super(project, storage);
    }

    public DefaultIssue forRule(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    public DefaultIssue gap(@Nullable Double gap) {
        Preconditions.checkArgument((gap == null || gap >= 0.0 ? 1 : 0) != 0, (String)String.format("Gap must be greater than or equal 0 (got %s)", gap));
        this.gap = gap;
        return this;
    }

    public DefaultIssue overrideSeverity(@Nullable Severity severity) {
        this.overriddenSeverity = severity;
        return this;
    }

    public DefaultIssue overrideImpact(SoftwareQuality softwareQuality, org.sonar.api.issue.impact.Severity severity) {
        this.overridenImpacts.put(softwareQuality, severity);
        return this;
    }

    public DefaultIssue setQuickFixAvailable(boolean quickFixAvailable) {
        this.quickFixAvailable = quickFixAvailable;
        return this;
    }

    public NewQuickFix newQuickFix() {
        return new NoOpNewQuickFix();
    }

    public NewIssue addQuickFix(NewQuickFix newQuickFix) {
        this.quickFixAvailable = true;
        return this;
    }

    public DefaultIssue setRuleDescriptionContextKey(@Nullable String ruleDescriptionContextKey) {
        this.ruleDescriptionContextKey = ruleDescriptionContextKey;
        return this;
    }

    public DefaultIssue setCodeVariants(@Nullable Iterable<String> codeVariants) {
        if (codeVariants != null) {
            ArrayList<String> codeVariantsList = new ArrayList<String>();
            codeVariants.forEach(codeVariantsList::add);
            this.codeVariants = codeVariantsList;
        }
        return this;
    }

    public DefaultIssue addInternalTag(String tag) {
        if (this.internalTags == null) {
            this.setInternalTags((Collection)List.of());
        }
        this.internalTags.add(tag);
        return this;
    }

    public DefaultIssue addInternalTags(Collection<String> tags) {
        if (this.internalTags == null) {
            this.setInternalTags((Collection)List.of());
        }
        this.internalTags.addAll(tags);
        return this;
    }

    public DefaultIssue setInternalTags(@Nullable Collection<String> tags) {
        if (tags != null) {
            this.internalTags = new ArrayList<String>(tags);
        }
        return this;
    }

    public boolean isQuickFixAvailable() {
        return this.quickFixAvailable;
    }

    public Optional<String> ruleDescriptionContextKey() {
        return Optional.ofNullable(this.ruleDescriptionContextKey);
    }

    public List<QuickFix> quickFixes() {
        throw new UnsupportedOperationException();
    }

    public List<String> codeVariants() {
        return this.codeVariants;
    }

    public List<String> internalTags() {
        return this.internalTags;
    }

    public Severity overriddenSeverity() {
        return this.overriddenSeverity;
    }

    public Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> overridenImpacts() {
        return this.overridenImpacts;
    }

    public Double gap() {
        return this.gap;
    }

    @Override
    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    @Override
    public void doSave() {
        Objects.requireNonNull(this.ruleKey, "ruleKey is mandatory on issue");
        Preconditions.checkState((this.primaryLocation != null ? 1 : 0) != 0, (String)"Primary location is mandatory on every issue");
        this.storage.store((Issue)this);
    }
}

