/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.impl.ws;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.sonar.api.impl.ws.PartImpl;
import org.sonar.api.server.ws.LocalConnector;
import org.sonar.api.server.ws.Request;

public class SimpleGetRequest
extends Request {
    private final Map<String, String[]> params = new HashMap<String, String[]>();
    private final Map<String, Request.Part> parts = new HashMap<String, Request.Part>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private String mediaType = "application/json";
    private String path;

    public String method() {
        return "GET";
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public SimpleGetRequest setMediaType(String mediaType) {
        Objects.requireNonNull(mediaType);
        this.mediaType = mediaType;
        return this;
    }

    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    public String param(String key) {
        String[] strings = this.params.get(key);
        return strings == null || strings.length == 0 ? null : strings[0];
    }

    public List<String> multiParam(String key) {
        String value = this.param(key);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    @CheckForNull
    public List<String> paramAsStrings(String key) {
        String value = this.param(key);
        if (value == null) {
            return null;
        }
        return Arrays.stream(value.split(",")).map(String::trim).filter(x -> !x.isEmpty()).toList();
    }

    public InputStream paramAsInputStream(String key) {
        return IOUtils.toInputStream((String)this.param(key), (Charset)StandardCharsets.UTF_8);
    }

    public SimpleGetRequest setParam(String key, @Nullable String value) {
        if (value != null) {
            this.params.put(key, new String[]{value});
        }
        return this;
    }

    public Map<String, String[]> getParams() {
        return this.params;
    }

    public Request.Part paramAsPart(String key) {
        return this.parts.get(key);
    }

    public SimpleGetRequest setPart(String key, InputStream input, String fileName) {
        this.parts.put(key, new PartImpl(input, fileName));
        return this;
    }

    public LocalConnector localConnector() {
        throw new UnsupportedOperationException();
    }

    public String getPath() {
        return this.path;
    }

    public SimpleGetRequest setPath(String path) {
        this.path = path;
        return this;
    }

    public Optional<String> header(String name) {
        return Optional.ofNullable(this.headers.get(name));
    }

    public SimpleGetRequest setHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }
}

