/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.impl.utils;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class WorkDuration
implements Serializable {
    static final int DAY_POSITION_IN_LONG = 10000;
    static final int HOUR_POSITION_IN_LONG = 100;
    static final int MINUTE_POSITION_IN_LONG = 1;
    private int hoursInDay;
    private long durationInMinutes;
    private int days;
    private int hours;
    private int minutes;

    private WorkDuration(long durationInMinutes, int days, int hours, int minutes, int hoursInDay) {
        this.durationInMinutes = durationInMinutes;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.hoursInDay = hoursInDay;
    }

    public static WorkDuration create(int days, int hours, int minutes, int hoursInDay) {
        long durationInSeconds = 60L * (long)days * (long)hoursInDay;
        durationInSeconds += 60L * (long)hours;
        return new WorkDuration(durationInSeconds += (long)minutes, days, hours, minutes, hoursInDay);
    }

    public static WorkDuration createFromValueAndUnit(int value, UNIT unit, int hoursInDay) {
        switch (unit) {
            case DAYS: {
                return WorkDuration.create(value, 0, 0, hoursInDay);
            }
            case HOURS: {
                return WorkDuration.create(0, value, 0, hoursInDay);
            }
            case MINUTES: {
                return WorkDuration.create(0, 0, value, hoursInDay);
            }
        }
        throw new IllegalStateException("Cannot create work duration");
    }

    static WorkDuration createFromLong(long duration, int hoursInDay) {
        int days = 0;
        int hours = 0;
        int minutes = 0;
        long time = duration;
        Long currentTime = time / 10000L;
        if (currentTime > 0L) {
            days = currentTime.intValue();
            time -= currentTime * 10000L;
        }
        if ((currentTime = Long.valueOf(time / 100L)) > 0L) {
            hours = currentTime.intValue();
            time -= currentTime * 100L;
        }
        if ((currentTime = Long.valueOf(time / 1L)) > 0L) {
            minutes = currentTime.intValue();
        }
        return WorkDuration.create(days, hours, minutes, hoursInDay);
    }

    static WorkDuration createFromMinutes(long duration, int hoursInDay) {
        int days = (int)((double)duration / (double)hoursInDay / 60.0);
        Long currentDurationInMinutes = duration - 60L * (long)days * (long)hoursInDay;
        int hours = (int)((double)currentDurationInMinutes.longValue() / 60.0);
        currentDurationInMinutes = currentDurationInMinutes - 60L * (long)hours;
        return new WorkDuration(duration, days, hours, currentDurationInMinutes.intValue(), hoursInDay);
    }

    public double toWorkingDays() {
        return (double)this.durationInMinutes / 60.0 / (double)this.hoursInDay;
    }

    public long toLong() {
        int workingDays = this.days;
        int workingHours = this.hours;
        if (this.hours >= this.hoursInDay) {
            int nbAdditionalDays = this.hours / this.hoursInDay;
            workingDays += nbAdditionalDays;
            workingHours = this.hours - nbAdditionalDays * this.hoursInDay;
        }
        return 1L * (long)workingDays * 10000L + (long)(workingHours * 100) + (long)(this.minutes * 1);
    }

    public long toMinutes() {
        return this.durationInMinutes;
    }

    public WorkDuration add(@Nullable WorkDuration with) {
        if (with != null) {
            return WorkDuration.createFromMinutes(this.toMinutes() + with.toMinutes(), this.hoursInDay);
        }
        return this;
    }

    public WorkDuration subtract(@Nullable WorkDuration with) {
        if (with != null) {
            return WorkDuration.createFromMinutes(this.toMinutes() - with.toMinutes(), this.hoursInDay);
        }
        return this;
    }

    public WorkDuration multiply(int factor) {
        return WorkDuration.createFromMinutes(this.toMinutes() * (long)factor, this.hoursInDay);
    }

    public int days() {
        return this.days;
    }

    public int hours() {
        return this.hours;
    }

    public int minutes() {
        return this.minutes;
    }

    int hoursInDay() {
        return this.hoursInDay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkDuration that = (WorkDuration)o;
        return this.durationInMinutes == that.durationInMinutes;
    }

    public int hashCode() {
        return (int)(this.durationInMinutes ^ this.durationInMinutes >>> 32);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static enum UNIT {
        DAYS,
        HOURS,
        MINUTES;

    }
}

