/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.rule.internal.NewRuleParam;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;

public class NewRule {
    private static final String DEFAULT_SEVERITY = Severity.defaultSeverity();
    final RuleKey key;
    Integer id;
    String name;
    String description;
    String severity = DEFAULT_SEVERITY;
    String type;
    String internalKey;
    RuleStatus status = RuleStatus.defaultStatus();
    Map<String, NewRuleParam> params = new HashMap<String, NewRuleParam>();

    public NewRule(RuleKey key) {
        this.key = key;
    }

    public NewRule setId(@Nullable Integer id) {
        this.id = id;
        return this;
    }

    public NewRule setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public NewRule setName(@Nullable String s) {
        this.name = s;
        return this;
    }

    public NewRule setSeverity(@Nullable String severity) {
        this.severity = StringUtils.defaultIfBlank((String)severity, (String)DEFAULT_SEVERITY);
        return this;
    }

    public NewRule setType(@Nullable String type) {
        this.type = type;
        return this;
    }

    public NewRule setStatus(@Nullable RuleStatus s) {
        this.status = (RuleStatus)ObjectUtils.defaultIfNull((Object)s, (Object)RuleStatus.defaultStatus());
        return this;
    }

    public NewRule setInternalKey(@Nullable String s) {
        this.internalKey = s;
        return this;
    }

    public NewRuleParam addParam(String paramKey) {
        if (this.params.containsKey(paramKey)) {
            throw new IllegalStateException(String.format("Parameter '%s' already exists on rule '%s'", paramKey, this.key));
        }
        NewRuleParam param = new NewRuleParam(paramKey);
        this.params.put(paramKey, param);
        return param;
    }
}

