/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.fs.IndexedFile;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.utils.PathUtils;

@Immutable
public class DefaultIndexedFile
extends DefaultInputComponent
implements IndexedFile {
    private static AtomicInteger intGenerator = new AtomicInteger(0);
    private final String projectRelativePath;
    private final String moduleRelativePath;
    private final String projectKey;
    private final String language;
    private final InputFile.Type type;
    private final Path absolutePath;
    private final SensorStrategy sensorStrategy;

    public DefaultIndexedFile(String projectKey, Path baseDir, String relativePath, @Nullable String language) {
        this(baseDir.resolve(relativePath), projectKey, relativePath, relativePath, InputFile.Type.MAIN, language, intGenerator.getAndIncrement(), new SensorStrategy());
    }

    public DefaultIndexedFile(Path absolutePath, String projectKey, String projectRelativePath, String moduleRelativePath, InputFile.Type type, @Nullable String language, int batchId, SensorStrategy sensorStrategy) {
        super(batchId);
        this.projectKey = projectKey;
        this.projectRelativePath = PathUtils.sanitize((String)projectRelativePath);
        this.moduleRelativePath = PathUtils.sanitize((String)moduleRelativePath);
        this.type = type;
        this.language = language;
        this.sensorStrategy = sensorStrategy;
        this.absolutePath = absolutePath;
    }

    public String relativePath() {
        return this.sensorStrategy.isGlobal() ? this.projectRelativePath : this.moduleRelativePath;
    }

    public String getModuleRelativePath() {
        return this.moduleRelativePath;
    }

    public String getProjectRelativePath() {
        return this.projectRelativePath;
    }

    public String absolutePath() {
        return PathUtils.sanitize((String)this.path().toString());
    }

    public File file() {
        return this.path().toFile();
    }

    public Path path() {
        return this.absolutePath;
    }

    public InputStream inputStream() throws IOException {
        return Files.newInputStream(this.path(), new OpenOption[0]);
    }

    @CheckForNull
    public String language() {
        return this.language;
    }

    public InputFile.Type type() {
        return this.type;
    }

    public String key() {
        return this.projectKey + ":" + this.projectRelativePath;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        DefaultIndexedFile that = (DefaultIndexedFile)o;
        return this.projectRelativePath.equals(that.projectRelativePath);
    }

    @Override
    public int hashCode() {
        return this.projectRelativePath.hashCode();
    }

    @Override
    public String toString() {
        return this.projectRelativePath;
    }

    public boolean isFile() {
        return true;
    }

    public String filename() {
        return this.path().getFileName().toString();
    }

    public URI uri() {
        return this.path().toUri();
    }
}

