/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config.internal;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.config.internal.AesECBCipher;
import org.sonar.api.config.internal.AesGCMCipher;
import org.sonar.api.config.internal.Base64Cipher;
import org.sonar.api.config.internal.Cipher;

public final class Encryption {
    private static final String BASE64_ALGORITHM = "b64";
    private static final String AES_ECB_ALGORITHM = "aes";
    private static final String AES_GCM_ALGORITHM = "aes-gcm";
    private final AesECBCipher aesECBCipher;
    private final AesGCMCipher aesGCMCipher;
    private final Map<String, Cipher> ciphers;
    private static final Pattern ENCRYPTED_PATTERN = Pattern.compile("\\{(.*?)\\}(.*)");

    public Encryption(@Nullable String pathToSecretKey) {
        this.aesECBCipher = new AesECBCipher(pathToSecretKey);
        this.aesGCMCipher = new AesGCMCipher(pathToSecretKey);
        this.ciphers = new HashMap<String, Cipher>();
        this.ciphers.put(BASE64_ALGORITHM, new Base64Cipher());
        this.ciphers.put(AES_ECB_ALGORITHM, this.aesECBCipher);
        this.ciphers.put(AES_GCM_ALGORITHM, this.aesGCMCipher);
    }

    public void setPathToSecretKey(@Nullable String pathToSecretKey) {
        this.aesECBCipher.setPathToSecretKey(pathToSecretKey);
        this.aesGCMCipher.setPathToSecretKey(pathToSecretKey);
    }

    public boolean hasSecretKey() {
        return this.aesGCMCipher.hasSecretKey();
    }

    public boolean isEncrypted(String value) {
        return value.indexOf(123) == 0 && value.indexOf(125) > 1;
    }

    public String encrypt(String clearText) {
        return this.encrypt(AES_GCM_ALGORITHM, clearText);
    }

    public String scramble(String clearText) {
        return this.encrypt(BASE64_ALGORITHM, clearText);
    }

    public String generateRandomSecretKey() {
        return this.aesGCMCipher.generateRandomSecretKey();
    }

    public String decrypt(String encryptedText) {
        Cipher cipher;
        Matcher matcher = ENCRYPTED_PATTERN.matcher(encryptedText);
        if (matcher.matches() && (cipher = this.ciphers.get(matcher.group(1).toLowerCase(Locale.ENGLISH))) != null) {
            return cipher.decrypt(matcher.group(2));
        }
        return encryptedText;
    }

    private String encrypt(String algorithm, String clearText) {
        Cipher cipher = this.ciphers.get(algorithm);
        if (cipher == null) {
            throw new IllegalArgumentException("Unknown cipher algorithm: " + algorithm);
        }
        return String.format("{%s}%s", algorithm, cipher.encrypt(clearText));
    }
}

