/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.AbstractFilePredicate;

public class FilenamePredicate
extends AbstractFilePredicate {
    private final String filename;

    public FilenamePredicate(String filename) {
        this.filename = filename;
    }

    @Override
    public boolean apply(InputFile inputFile) {
        return this.filename.equals(FilenamePredicate.getFilename(inputFile));
    }

    @Override
    public Iterable<InputFile> get(FileSystem.Index index) {
        return index.getFilesByName(this.filename);
    }

    public static String getFilename(InputFile inputFile) {
        return inputFile.file().getName();
    }
}

