/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultIndexedFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.FileMetadata;
import org.sonar.api.batch.fs.internal.Metadata;
import org.sonar.api.utils.PathUtils;

public class TestInputFileBuilder {
    private static int batchId = 1;
    private final int id;
    private final String relativePath;
    private final String moduleKey;
    private Path moduleBaseDir;
    private String language;
    private InputFile.Type type = InputFile.Type.MAIN;
    private InputFile.Status status;
    private int lines = -1;
    private Charset charset;
    private int lastValidOffset = -1;
    private String hash;
    private int nonBlankLines;
    private int[] originalLineOffsets;
    private boolean publish = true;

    public TestInputFileBuilder(String moduleKey, String relativePath) {
        this(moduleKey, relativePath, batchId++);
    }

    public TestInputFileBuilder(String moduleKey, String relativePath, int id) {
        this.moduleKey = moduleKey;
        this.moduleBaseDir = Paths.get(moduleKey, new String[0]);
        this.relativePath = PathUtils.sanitize(relativePath);
        this.id = id;
    }

    public static int nextBatchId() {
        return batchId++;
    }

    public TestInputFileBuilder setModuleBaseDir(Path moduleBaseDir) {
        this.moduleBaseDir = moduleBaseDir.normalize();
        return this;
    }

    public TestInputFileBuilder setLanguage(@Nullable String language) {
        this.language = language;
        return this;
    }

    public TestInputFileBuilder setType(InputFile.Type type) {
        this.type = type;
        return this;
    }

    public TestInputFileBuilder setStatus(InputFile.Status status) {
        this.status = status;
        return this;
    }

    public TestInputFileBuilder setLines(int lines) {
        this.lines = lines;
        return this;
    }

    public TestInputFileBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public TestInputFileBuilder setLastValidOffset(int lastValidOffset) {
        this.lastValidOffset = lastValidOffset;
        return this;
    }

    public TestInputFileBuilder setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public TestInputFileBuilder setNonBlankLines(int nonBlankLines) {
        this.nonBlankLines = nonBlankLines;
        return this;
    }

    public TestInputFileBuilder setOriginalLineOffsets(int[] originalLineOffsets) {
        this.originalLineOffsets = originalLineOffsets;
        return this;
    }

    public TestInputFileBuilder setPublish(boolean publish) {
        this.publish = publish;
        return this;
    }

    public TestInputFileBuilder setMetadata(Metadata metadata) {
        this.setLines(metadata.lines());
        this.setLastValidOffset(metadata.lastValidOffset());
        this.setNonBlankLines(metadata.nonBlankLines());
        this.setHash(metadata.hash());
        this.setOriginalLineOffsets(metadata.originalLineOffsets());
        return this;
    }

    public TestInputFileBuilder initMetadata(String content) {
        return this.setMetadata(new FileMetadata().readMetadata(new StringReader(content)));
    }

    public DefaultInputFile build() {
        DefaultIndexedFile indexedFile = new DefaultIndexedFile(this.moduleKey, this.moduleBaseDir, this.relativePath, this.type, this.id);
        indexedFile.setLanguage(this.language);
        DefaultInputFile inputFile = new DefaultInputFile(indexedFile, f -> f.setMetadata(new Metadata(this.lines, this.nonBlankLines, this.hash, this.originalLineOffsets, this.lastValidOffset)));
        inputFile.setStatus(this.status);
        inputFile.setCharset(this.charset);
        inputFile.setPublish(this.publish);
        return inputFile;
    }
}

