/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.DefaultActiveRule;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.internal.google.common.collect.ImmutableListMultimap;
import org.sonar.api.rule.RuleKey;

@Immutable
public class DefaultActiveRules
implements ActiveRules {
    private final ImmutableListMultimap<String, ActiveRule> activeRulesByRepository;
    private final Map<String, Map<String, ActiveRule>> activeRulesByRepositoryAndKey = new HashMap<String, Map<String, ActiveRule>>();
    private final Map<String, Map<String, ActiveRule>> activeRulesByRepositoryAndInternalKey = new HashMap<String, Map<String, ActiveRule>>();
    private final ImmutableListMultimap<String, ActiveRule> activeRulesByLanguage;

    public DefaultActiveRules(Collection<NewActiveRule> newActiveRules) {
        ImmutableListMultimap.Builder repoBuilder = ImmutableListMultimap.builder();
        ImmutableListMultimap.Builder langBuilder = ImmutableListMultimap.builder();
        for (NewActiveRule newAR : newActiveRules) {
            DefaultActiveRule ar = new DefaultActiveRule(newAR);
            String repo = ar.ruleKey().repository();
            repoBuilder.put(repo, ar);
            if (ar.language() != null) {
                langBuilder.put(ar.language(), ar);
            }
            this.activeRulesByRepositoryAndKey.computeIfAbsent(repo, r -> new HashMap()).put(ar.ruleKey().rule(), ar);
            String internalKey = ar.internalKey();
            if (internalKey == null) continue;
            this.activeRulesByRepositoryAndInternalKey.computeIfAbsent(repo, r -> new HashMap()).put(internalKey, ar);
        }
        this.activeRulesByRepository = repoBuilder.build();
        this.activeRulesByLanguage = langBuilder.build();
    }

    @Override
    public ActiveRule find(RuleKey ruleKey) {
        return (ActiveRule)this.activeRulesByRepositoryAndKey.getOrDefault(ruleKey.repository(), Collections.emptyMap()).get(ruleKey.rule());
    }

    @Override
    public Collection<ActiveRule> findAll() {
        return this.activeRulesByRepository.values();
    }

    @Override
    public Collection<ActiveRule> findByRepository(String repository) {
        return this.activeRulesByRepository.get((Object)repository);
    }

    @Override
    public Collection<ActiveRule> findByLanguage(String language) {
        return this.activeRulesByLanguage.get((Object)language);
    }

    @Override
    public ActiveRule findByInternalKey(String repository, String internalKey) {
        return this.activeRulesByRepositoryAndInternalKey.containsKey(repository) ? this.activeRulesByRepositoryAndInternalKey.get(repository).get(internalKey) : null;
    }
}

