/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.scm;

import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.scm.BlameCommand;

@ScannerSide
@InstantiationStrategy(value="PER_BATCH")
@ExtensionPoint
public abstract class ScmProvider {
    public abstract String key();

    public boolean supports(File baseDir) {
        return false;
    }

    public BlameCommand blameCommand() {
        throw new UnsupportedOperationException(this.formatUnsupportedMessage("Blame command"));
    }

    @Nullable
    public Set<Path> branchChangedFiles(String targetBranchName, Path rootBaseDir) {
        return null;
    }

    public Path relativePathFromScmRoot(Path path) {
        throw new UnsupportedOperationException(this.formatUnsupportedMessage("Getting relative path from SCM root"));
    }

    public String revisionId(Path path) {
        throw new UnsupportedOperationException(this.formatUnsupportedMessage("Getting revision id"));
    }

    private String formatUnsupportedMessage(String prefix) {
        return prefix + " is not supported by " + this.key() + " provider";
    }
}

