/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.NumberUtils;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.collect.SortedMultiset;
import org.sonar.api.internal.google.common.collect.TreeMultiset;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureBuilder;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MultisetDistributionFormat;
import org.sonar.api.utils.KeyValueFormat;

@Deprecated
public class RangeDistributionBuilder
implements MeasureBuilder {
    private final Metric<String> metric;
    private final SortedMultiset countBag = TreeMultiset.create();
    private boolean isEmpty = true;
    private Number[] bottomLimits;
    private RangeTransformer rangeValueTransformer;
    private boolean isValid = true;

    public RangeDistributionBuilder(Metric<String> metric, Number[] bottomLimits) {
        Objects.requireNonNull(metric, "Metric must not be null");
        Preconditions.checkArgument(metric.isDataType(), "Metric %s must have data type", metric.key());
        this.metric = metric;
        this.init(bottomLimits);
    }

    public RangeDistributionBuilder(Metric<String> metric) {
        this.metric = metric;
    }

    private void init(Number[] bottomLimits) {
        this.bottomLimits = new Number[bottomLimits.length];
        System.arraycopy(bottomLimits, 0, this.bottomLimits, 0, this.bottomLimits.length);
        Arrays.sort(this.bottomLimits);
        this.changeDoublesToInts();
        this.doClear();
        this.rangeValueTransformer = new RangeTransformer();
    }

    private void changeDoublesToInts() {
        boolean onlyInts = true;
        for (Number bottomLimit : this.bottomLimits) {
            if (NumberUtils.compare((double)bottomLimit.intValue(), bottomLimit.doubleValue()) == 0) continue;
            onlyInts = false;
        }
        if (onlyInts) {
            for (int i = 0; i < this.bottomLimits.length; ++i) {
                this.bottomLimits[i] = this.bottomLimits[i].intValue();
            }
        }
    }

    public Number[] getBottomLimits() {
        return this.bottomLimits;
    }

    public RangeDistributionBuilder add(Number value) {
        return this.add(value, 1);
    }

    public RangeDistributionBuilder add(@Nullable Number value, int count) {
        if (value != null && RangeDistributionBuilder.greaterOrEqualsThan(value, this.bottomLimits[0])) {
            this.countBag.add(this.rangeValueTransformer.apply(value), count);
            this.isEmpty = false;
        }
        return this;
    }

    private RangeDistributionBuilder addLimitCount(Number limit, int count) {
        for (Number bottomLimit : this.bottomLimits) {
            if (NumberUtils.compare(bottomLimit.doubleValue(), limit.doubleValue()) != 0) continue;
            this.countBag.add(this.rangeValueTransformer.apply(limit), count);
            this.isEmpty = false;
            return this;
        }
        this.isValid = false;
        return this;
    }

    public RangeDistributionBuilder add(@Nullable Measure<String> measure) {
        if (measure != null && measure.getData() != null) {
            Map<Double, Double> map = KeyValueFormat.parse(measure.getData(), KeyValueFormat.newDoubleConverter(), KeyValueFormat.newDoubleConverter());
            Number[] limits = map.keySet().toArray(new Number[map.size()]);
            if (this.bottomLimits == null) {
                this.init(limits);
            } else if (!RangeDistributionBuilder.areSameLimits(this.bottomLimits, map.keySet())) {
                this.isValid = false;
            }
            if (this.isValid) {
                for (Map.Entry<Double, Double> entry : map.entrySet()) {
                    this.addLimitCount(entry.getKey(), entry.getValue().intValue());
                }
            }
        }
        return this;
    }

    private static boolean areSameLimits(Number[] bottomLimits, Set<Double> limits) {
        if (limits.size() == bottomLimits.length) {
            for (Number l : bottomLimits) {
                if (limits.contains(l.doubleValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public RangeDistributionBuilder clear() {
        this.doClear();
        return this;
    }

    private void doClear() {
        this.countBag.clear();
        if (this.bottomLimits != null) {
            Collections.addAll(this.countBag, this.bottomLimits);
        }
        this.isEmpty = true;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public Measure<String> build() {
        return this.build(true);
    }

    public Measure<String> build(boolean allowEmptyData) {
        if (this.isValid && (!this.isEmpty || allowEmptyData)) {
            return new Measure<String>(this.metric, MultisetDistributionFormat.format(this.countBag));
        }
        return null;
    }

    private static boolean greaterOrEqualsThan(Number n1, Number n2) {
        return NumberUtils.compare(n1.doubleValue(), n2.doubleValue()) >= 0;
    }

    private class RangeTransformer
    implements Function<Number, Number> {
        private RangeTransformer() {
        }

        @Override
        public Number apply(Number n) {
            for (int i = RangeDistributionBuilder.this.bottomLimits.length - 1; i >= 0; --i) {
                if (!RangeDistributionBuilder.greaterOrEqualsThan(n, RangeDistributionBuilder.this.bottomLimits[i])) continue;
                return RangeDistributionBuilder.this.bottomLimits[i];
            }
            return null;
        }
    }
}

