/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sonar.api.resources.Resource;

public final class Qualifiers {
    public static final String VIEW = "VW";
    public static final String SUBVIEW = "SVW";
    public static final String APP = "APP";
    @Deprecated
    public static final String LIBRARY = "LIB";
    public static final String PROJECT = "TRK";
    public static final String MODULE = "BRC";
    public static final String DIRECTORY = "DIR";
    public static final String FILE = "FIL";
    public static final String UNIT_TEST_FILE = "UTS";
    public static final List<String> ORDERED_BOTTOM_UP = Collections.unmodifiableList(Arrays.asList("FIL", "UTS", "DIR", "BRC", "TRK", "APP", "SVW", "VW"));

    private Qualifiers() {
    }

    public static boolean isView(Resource resource, boolean acceptSubViews) {
        boolean isView = Objects.equals(VIEW, resource.getQualifier());
        if (!isView && acceptSubViews) {
            isView = Objects.equals(SUBVIEW, resource.getQualifier());
        }
        return isView;
    }

    public static boolean isSubview(Resource resource) {
        return Objects.equals(SUBVIEW, resource.getScope());
    }

    public static boolean isProject(Resource resource, boolean acceptModules) {
        boolean isProject = Objects.equals(PROJECT, resource.getQualifier());
        if (!isProject && acceptModules) {
            isProject = Objects.equals(MODULE, resource.getQualifier());
        }
        return isProject;
    }

    public static boolean isModule(Resource resource) {
        return Objects.equals(MODULE, resource.getQualifier());
    }

    public static boolean isDirectory(Resource resource) {
        return Objects.equals(DIRECTORY, resource.getQualifier());
    }

    public static boolean isFile(Resource resource) {
        return Objects.equals(FILE, resource.getQualifier());
    }
}

