/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem;

import java.util.Arrays;
import java.util.stream.Stream;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.internal.apachecommons.lang.StringUtils;

@ScannerSide
public class FileExclusions {
    private final Configuration settings;

    public FileExclusions(Configuration settings) {
        this.settings = settings;
    }

    public String[] sourceInclusions() {
        return this.inclusions("sonar.inclusions");
    }

    public String[] testInclusions() {
        return this.inclusions("sonar.test.inclusions");
    }

    private String[] inclusions(String propertyKey) {
        return (String[])Arrays.stream(this.settings.getStringArray(propertyKey)).map(StringUtils::trim).filter(s -> !"**/*".equals(s)).filter(s -> !"file:**/*".equals(s)).toArray(String[]::new);
    }

    public String[] sourceExclusions() {
        return this.exclusions("sonar.global.exclusions", "sonar.exclusions");
    }

    public String[] testExclusions() {
        return this.exclusions("sonar.global.test.exclusions", "sonar.test.exclusions");
    }

    private String[] exclusions(String globalExclusionsProperty, String exclusionsProperty) {
        String[] globalExclusions = this.settings.getStringArray(globalExclusionsProperty);
        String[] exclusions = this.settings.getStringArray(exclusionsProperty);
        return (String[])Stream.concat(Arrays.stream(globalExclusions), Arrays.stream(exclusions)).map(StringUtils::trim).toArray(String[]::new);
    }
}

